/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.record.interceptor.BigRequestInterceptor;
import com.xforceplus.janus.framework.record.interceptor.RequestInterceptor;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

public class WebMvcConfig
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(WebMvcConfig.class);
    private RequestInterceptor requestInterceptor;
    private BigRequestInterceptor bigRequestInterceptor;
    private HttpConfig httpConfig;

    public void addInterceptors(InterceptorRegistry registry) {
        if (!this.httpConfig.getWebfilter().isEnable()) {
            return;
        }
        Object[] excludePathPatterns = new String[]{"/**.html", "/**.js", "/janus/record/resend", "/error", "base/actuator"};
        if (this.httpConfig.getWebfilter() != null && StringUtils.isNotBlank((CharSequence)this.httpConfig.getWebfilter().getExclude())) {
            excludePathPatterns = (String[])ArrayUtils.addAll((Object[])excludePathPatterns, (Object[])this.httpConfig.getWebfilter().getExclude().split(","));
        }
        registry.addInterceptor((HandlerInterceptor)this.requestInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns((String[])excludePathPatterns);
        if (this.bigRequestInterceptor != null) {
            registry.addInterceptor((HandlerInterceptor)this.bigRequestInterceptor);
        }
    }

    public void setRequestInterceptor(RequestInterceptor requestInterceptor) {
        this.requestInterceptor = requestInterceptor;
    }

    public void setBigRequestInterceptor(BigRequestInterceptor bigRequestInterceptor) {
        this.bigRequestInterceptor = bigRequestInterceptor;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

