/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.record.domain.AccessContent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class AccessContentRepository {
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;
    private HttpConfig coreConfig;
    private static final String queryByIdSql = "select id,content from %s where id=:id";

    public void saveBatch(List<AccessContent> contents) {
        Map[] params = new Map[contents.size()];
        List rcMaps = BeanMapperUtil.mapList(contents, Map.class);
        rcMaps.toArray(params);
        this.namedPrmtrJdbcTemplate.batchUpdate(this.getInsertSql(), params);
    }

    private String getInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(AccessContent.getTableNameBySharding(this.coreConfig.getAccess().getShardType())).append("(");
        builder.append("id,content").append(")values(");
        builder.append(":id,:content").append(")");
        return builder.toString();
    }

    public AccessContent getById(final String id, String yyyyMMdd) {
        String tableName = StringUtils.isBlank((CharSequence)yyyyMMdd) ? AccessContent.getTableNameBySharding(this.coreConfig.getAccess().getShardType()) : AccessContent.getTableName(yyyyMMdd);
        String querySql = String.format(queryByIdSql, tableName);
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("id", id);
            }
        };
        AccessContent acc = null;
        try {
            acc = (AccessContent)this.namedPrmtrJdbcTemplate.queryForObject(querySql, (Map)param, (RowMapper)new RowMapper<AccessContent>(){

                public AccessContent mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessContent accessContent = new AccessContent(rs.getString("id"), rs.getString("content"));
                    return accessContent;
                }
            });
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return acc;
    }

    public void setNamedPrmtrJdbcTemplate(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate) {
        this.namedPrmtrJdbcTemplate = namedPrmtrJdbcTemplate;
    }

    public void setCoreConfig(HttpConfig coreConfig) {
        this.coreConfig = coreConfig;
    }
}

