/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.util.PageUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class AccessRecordRepository {
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;
    private HttpConfig httpConfig;
    private static final String QUERYSQL = "select id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len from %s where 1=1 ";
    private static final String queryByIdSql = "select id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len from %s where 1=1  and  id=:id";
    private static final String QUERYCOUNTSQL = "select count(1) from %s where 1=1";

    public void saveBatch(List<AccessRecord> records) {
        Map[] params = new Map[records.size()];
        List rcMaps = BeanMapperUtil.mapList(records, Map.class);
        rcMaps.toArray(params);
        this.namedPrmtrJdbcTemplate.batchUpdate(this.getInsertSql(), params);
    }

    private String getInsertSql() {
        StringBuilder builder = new StringBuilder();
        builder.append("insert into ").append(AccessRecord.getTableNameBySharding(this.httpConfig.getAccess().getShardType())).append("(");
        builder.append("id,request_method,client_project_id,server_project_id,api_id,action,cost_time,status,content_id,trace_id,serial_no,source_ip,request_time,req_data_len,rep_data_len").append(")values(");
        builder.append(":id,:requestMethod,:clientProjectId,:serverProjectId,:apiId,:action,:costTime,:status,:contentId,:traceId,:serialNo,:sourceIp,:requestTime,:reqDataLen,:repDataLen").append(")");
        return builder.toString();
    }

    public AccessRecord getById(final String id, String yyyyMMdd) {
        String tableName = StringUtils.isBlank((CharSequence)yyyyMMdd) ? AccessRecord.getTableNameBySharding(this.httpConfig.getAccess().getShardType()) : AccessRecord.getTableName(yyyyMMdd);
        String querySql = String.format(queryByIdSql, tableName);
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("id", id);
            }
        };
        AccessRecord acc = null;
        try {
            acc = (AccessRecord)this.namedPrmtrJdbcTemplate.queryForObject(querySql, (Map)param, (RowMapper)new RowMapper<AccessRecord>(){

                public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                    builder.id(rs.getString("id")).requestMethod(rs.getString("request_method")).action(rs.getString("action")).apiId(rs.getString("api_id")).traceId(rs.getString("trace_id")).reqDataLen(rs.getInt("req_data_len")).repDataLen(rs.getInt("rep_data_len")).serialNo(rs.getString("serial_no")).requestTime(rs.getString("request_time")).sourceIp(rs.getString("source_ip")).contentId(rs.getString("content_id")).status(rs.getInt("status")).clientProjectId(rs.getString("client_project_id")).serverProjectId(rs.getString("server_project_id")).costTime(rs.getLong("cost_time"));
                    return builder.build();
                }
            });
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return acc;
    }

    public PageUtils queryForPage(RecordPageParam param) {
        String yyyyMMd = param.getRequestTime().replaceAll("-", "").substring(0, 8);
        if ("y".equals(this.httpConfig.getAccess().getShardType())) {
            yyyyMMd = yyyyMMd.substring(0, 4);
        } else if ("m".equals(this.httpConfig.getAccess().getShardType())) {
            yyyyMMd = yyyyMMd.substring(0, 6);
        }
        String tableName = StringUtils.isBlank((CharSequence)yyyyMMd) ? AccessRecord.getTableNameBySharding(this.httpConfig.getAccess().getShardType()) : AccessRecord.getTableName(yyyyMMd);
        String querySql = String.format(QUERYSQL, tableName);
        String queryCountSql = String.format(QUERYCOUNTSQL, tableName);
        HashMap<String, String> params = new HashMap<String, String>();
        if (StringUtils.isNotBlank((CharSequence)param.getAction())) {
            querySql = querySql + " and action=:action";
            queryCountSql = queryCountSql + " and action=:action";
            params.put("action", param.getAction());
        }
        if (StringUtils.isNotBlank((CharSequence)param.getSerialNo())) {
            if (!param.getIsLike()) {
                querySql = querySql + " and serial_no=:serialNo";
                queryCountSql = queryCountSql + " and serial_no=:serialNo";
                params.put("serialNo", param.getSerialNo());
            } else {
                querySql = querySql + " and serial_no like concat(:serialNo,'%')";
                queryCountSql = queryCountSql + " and serial_no like concat(:serialNo,'%')";
                params.put("serialNo", param.getSerialNo());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)param.getStatus()) && !"1".equals(param.getStatus())) {
            querySql = querySql + " and status=:status";
            queryCountSql = queryCountSql + " and status=:status";
            params.put("status", param.getStatus());
        }
        Integer rows = (Integer)this.namedPrmtrJdbcTemplate.queryForObject(queryCountSql, params, Integer.class);
        List accs = null;
        if (rows > 0) {
            querySql = param.getPage() <= 1 ? querySql + " limit 0," + param.getSize() : querySql + " limit " + (param.getPage() - 1) * param.getSize() + "," + param.getSize();
            accs = this.namedPrmtrJdbcTemplate.query(querySql, params, (RowMapper)new RowMapper<AccessRecord>(){

                public AccessRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    AccessRecord.AccessRecordBuilder builder = AccessRecord.builder();
                    builder.id(rs.getString("id")).requestMethod(rs.getString("request_method")).action(rs.getString("action")).apiId(rs.getString("api_id")).traceId(rs.getString("trace_id")).reqDataLen(rs.getInt("req_data_len")).repDataLen(rs.getInt("rep_data_len")).serialNo(rs.getString("serial_no")).requestTime(rs.getString("request_time")).sourceIp(rs.getString("source_ip")).contentId(rs.getString("content_id")).status(rs.getInt("status")).clientProjectId(rs.getString("client_project_id")).serverProjectId(rs.getString("server_project_id")).costTime(rs.getLong("cost_time"));
                    return builder.build();
                }
            });
        }
        PageUtils pageUtils = new PageUtils(accs, rows, param.getSize(), param.getPage());
        return pageUtils;
    }

    public void setNamedPrmtrJdbcTemplate(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate) {
        this.namedPrmtrJdbcTemplate = namedPrmtrJdbcTemplate;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

