/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.record.domain.AccessContent;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.AccessContentRepository;
import com.xforceplus.janus.framework.record.portal.AccessRecordRepository;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import com.xforceplus.janus.framework.util.PageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class AccessRecordServiceImpl
implements AccessRecordService {
    private static final Logger log = LoggerFactory.getLogger(AccessRecordServiceImpl.class);
    private ServerProperties serverProperties;
    private AccessRecordRepository accessRecordRepository;
    private AccessContentRepository accessContentRepository;
    private HttpConfig coreConfig;
    static Set<String> excludeHeaderSet = new HashSet<String>(){
        {
            this.add("content-length");
            this.add("user-agent");
            this.add("host");
            this.add("x-forwarded-cluster");
            this.add("web-server-type");
            this.add("RequestURI");
        }
    };

    @Override
    public PageUtils queryForPage(RecordPageParam param) {
        return this.accessRecordRepository.queryForPage(param);
    }

    @Override
    public boolean saveBatch(List<AccessRecord> records) {
        if (CollectionUtils.isEmpty(records)) {
            return false;
        }
        ArrayList<AccessContent> contents = new ArrayList<AccessContent>();
        records.forEach(r -> {
            if (StringUtils.isBlank((CharSequence)r.getId())) {
                r.setId(UniqIdUtils.getInstance().getUniqID());
            }
            if (StringUtils.isBlank((CharSequence)r.getContentId())) {
                r.setContentId(r.getId());
            }
            if (r.getAccessContent() != null) {
                contents.add(new AccessContent(r.getContentId(), JacksonUtil.getInstance().toJson((Object)r.getAccessContent())));
            }
        });
        this.accessRecordRepository.saveBatch(records);
        if (CollectionUtils.isNotEmpty(contents)) {
            this.accessContentRepository.saveBatch(contents);
        }
        return true;
    }

    @Override
    public AccessContent queryByConentId(String contentId, String requestTime) {
        String yyyyMMd = this.getTabSuffix(requestTime);
        AccessContent content = this.accessContentRepository.getById(contentId, yyyyMMd);
        return content;
    }

    private String getTabSuffix(String requestTime) {
        String yyyyMMd = requestTime.replaceAll("-", "").substring(0, 8);
        if ("y".equals(this.coreConfig.getAccess().getShardType())) {
            yyyyMMd = yyyyMMd.substring(0, 4);
        } else if ("m".equals(this.coreConfig.getAccess().getShardType())) {
            yyyyMMd = yyyyMMd.substring(0, 6);
        }
        return yyyyMMd;
    }

    @Override
    public AccessRecord getById(String id, String requestTime) {
        String yyyyMMd = this.getTabSuffix(requestTime);
        AccessRecord record = this.accessRecordRepository.getById(id, yyyyMMd);
        return record;
    }

    @Override
    public AccessRecord getRichRecord(String recordId, String requestTime) {
        String yyyyMMd = this.getTabSuffix(requestTime);
        AccessRecord record = this.accessRecordRepository.getById(recordId, yyyyMMd);
        if (record == null) {
            return record;
        }
        AccessContent content = this.queryByConentId(record.getContentId(), requestTime);
        if (content != null) {
            AccessContentDto contentDto = (AccessContentDto)JacksonUtil.getInstance().fromJson(content.getContent(), AccessContentDto.class);
            record.setAccessContent(contentDto);
        }
        return record;
    }

    @Override
    public boolean retryAccessRecord(String recordId, String requestTime) {
        AccessRecord record = this.getRichRecord(recordId, requestTime);
        return this.retryAccessRecord(record);
    }

    @Override
    public boolean retryAccessRecord(AccessRecord record) {
        HttpUtil.ResponseCus resp = null;
        HashMap<String, String> params = null;
        HashMap<String, String> headers = null;
        String url = "http://localhost:" + this.serverProperties.getPort() + record.getAccessContent().getRequestHeader().get("RequestURI");
        if (MapUtils.isNotEmpty(record.getAccessContent().getRequestHeader())) {
            headers = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : record.getAccessContent().getRequestHeader().entrySet()) {
                if (excludeHeaderSet.contains(entry.getKey().toLowerCase())) continue;
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(record.getAccessContent().getRequestParam())) {
            params = new HashMap<String, String>();
            params.putAll(record.getAccessContent().getRequestParam());
        }
        try {
            if (HttpMethod.GET.name().equalsIgnoreCase(record.getRequestMethod())) {
                resp = HttpUtil.doGetEntire((String)url, params, (boolean)false, headers);
            } else if (HttpMethod.POST.name().equalsIgnoreCase(record.getRequestMethod())) {
                resp = HttpUtil.doPostJsonEntire((String)url, (String)record.getAccessContent().getRequestBody(), headers, params);
            } else if (HttpMethod.DELETE.name().equalsIgnoreCase(record.getRequestMethod())) {
                String string = HttpUtil.doDelete((String)url, headers, params);
            } else if (HttpMethod.PUT.name().equalsIgnoreCase(record.getRequestMethod())) {
                resp = HttpUtil.doPutPatchEntire((String)url, (String)HttpMethod.PUT.name(), (String)record.getAccessContent().getRequestBody(), headers, params);
            } else if (HttpMethod.PATCH.name().equalsIgnoreCase(record.getRequestMethod())) {
                resp = HttpUtil.doPutPatchEntire((String)url, (String)HttpMethod.PATCH.name(), (String)record.getAccessContent().getRequestBody(), headers, params);
            }
        }
        catch (Exception ex) {
            return false;
        }
        return resp.getStatus() == HttpStatus.OK.value();
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setAccessRecordRepository(AccessRecordRepository accessRecordRepository) {
        this.accessRecordRepository = accessRecordRepository;
    }

    public void setAccessContentRepository(AccessContentRepository accessContentRepository) {
        this.accessContentRepository = accessContentRepository;
    }

    public void setCoreConfig(HttpConfig coreConfig) {
        this.coreConfig = coreConfig;
    }
}

