/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class BigDataTmpRepository {
    private static final Logger log = LoggerFactory.getLogger(BigDataTmpRepository.class);
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;
    private static final String insertSql = "insert into t_janus_big_request_tmp(task_id,task_index,content,created_time)values(:taskId,:taskIndex,:content,:createdTime)";
    private static final String queryByTaskId = "select * from  t_janus_big_request_tmp where task_id=:taskId order by task_index";

    public boolean saveBigDataTmp(BigRequestTmpDto requestBody) {
        try {
            Map param = (Map)BeanMapperUtil.map((Object)requestBody, Map.class);
            int count = this.namedPrmtrJdbcTemplate.update(insertSql, param);
            return count == 1;
        }
        catch (Exception ex) {
            log.error("saveBigDataTmp ", (Throwable)ex);
            return false;
        }
    }

    public List<BigRequestTmpDto> getByTaskId(final String taskId) {
        List acc = null;
        HashMap<String, String> param = new HashMap<String, String>(){
            {
                this.put("taskId", taskId);
            }
        };
        try {
            acc = this.namedPrmtrJdbcTemplate.query(queryByTaskId, (Map)param, (RowMapper)new RowMapper<BigRequestTmpDto>(){

                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    requestTmpDto.setContent(rs.getString("content"));
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));
                    return requestTmpDto;
                }
            });
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return acc;
    }

    public void setNamedPrmtrJdbcTemplate(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate) {
        this.namedPrmtrJdbcTemplate = namedPrmtrJdbcTemplate;
    }
}

