package com.xforceplus.apollo.client.netty;

import com.xforceplus.apollo.config.ClientConfig;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.pool.thread.ApolloThread;
import com.xforceplus.apollo.pool.thread.ApolloThreadPool;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.ZipUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.MsgHttpConsumer;
import lombok.Getter;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2023/6/29下午2:29
 */

@Slf4j
public class MCFactory {

    static volatile MCFactory instance = null;
    private static volatile boolean autoAck = true;
    static final ApolloThread[] receiveThreads = new ApolloThread[ClientConfig.getConfig().getIntProperty("receive.thread.num", 1)];

    /**
     * key：eventType,value:action
     */
    public static Map<String, String> eventActionMap = new HashMap<>();

    @Setter
    @Getter
    private static HttpConfig httpConfig;

    private MCFactory() {
        SealedMessageCache.init();
    }

    public static com.xforceplus.apollo.client.netty.MCFactory getInstance(String userId, String host, int port) {
        if (MsgHttpConsumer.isPullMsg()) {
            if (instance == null) {
                synchronized (com.xforceplus.apollo.client.netty.MCFactory.class) {
                    if (instance == null) {
                        instance = new com.xforceplus.apollo.client.netty.MCFactory();
                    }
                }
            }
        } else {
            if (instance == null) {
                Class var3 = com.xforceplus.apollo.client.netty.MCFactory.class;
                synchronized (com.xforceplus.apollo.client.netty.MCFactory.class) {
                    if (instance == null) {
                        NettyTCPClient.getInstance(userId, host, port);

                        for (int i = 0; i < receiveThreads.length; ++i) {
                            ApolloThread apolloThread = new ReceiveMessageThread();
                            apolloThread.setThreadName("receiveThread-" + i);
                            log.info("启动线程~~~~~~{}", apolloThread.getThreadName());
                            receiveThreads[i] = apolloThread;
                            ApolloThreadPool.getInstance().submit(apolloThread);
                        }

                        instance = new MCFactory();
                    }
                }
            }
        }
        return instance;
    }

    public static com.xforceplus.apollo.client.netty.MCFactory getInstance() {
        if (instance == null) {
            throw new RuntimeException("请先有参初始化...");
        } else {
            return instance;
        }
    }

    public void registerListener(IMessageListener messageListener) {
        for (int i = 0; i < receiveThreads.length; ++i) {
            ((ReceiveMessageThread) receiveThreads[i]).registerListener(messageListener);
            log.info("注册消息监听~~~~~~{}", i);
        }

    }

    public void removeListener() {
        for (int i = 0; i < receiveThreads.length; ++i) {
            ((ReceiveMessageThread) receiveThreads[i]).removeListener();
            log.info("移除消息监听~~~~~~{}", i);
        }

    }

    public synchronized boolean sendMessage(SealedMessage sealedMessage) throws Exception {
        boolean result = false;

        if (StringUtils.isBlank(sealedMessage.getHeader().getPayLoadId()) && StringUtils.isBlank((CharSequence) sealedMessage.getHeader().getOthers().get("payLoadId"))) {
            throw new RuntimeException("业务号payLoadId不能为空!");
        } else {
            String compressFlag = (String) sealedMessage.getHeader().getOthers().get("bigDataCompress");
            if (!StringUtils.isNotBlank(compressFlag) || !"true".equalsIgnoreCase(compressFlag)) {
                sealedMessage = ZipUtil.compress(sealedMessage);
                if (null == sealedMessage) {
                    throw new Exception("压缩异常:消息体过大或内存不足");
                }
            }

            if (MsgHttpConsumer.isPullMsg()) {
                String sendMsgAction = eventActionMap.get(sealedMessage.getHeader().getRequestName());
                //调用集成平台http接口发送消息
                if (StringUtils.isBlank(sendMsgAction)) {
                    sendMsgAction = HttpConfig.getConfig("sendMsgAction");
                    if (StringUtils.isBlank(sendMsgAction)) {
                        log.error("没有发送消息{}权限", sealedMessage.getHeader().getRequestName());
                        return false;
                    }
                }

                Map<String, Object> msgMap = new HashMap<>();
                msgMap.put("message", sealedMessage.getPayload().getObj().toString());
                msgMap.put("properties", sealedMessage.getHeader().getOthers());

                Map<String, String> headers = new HashMap<>();
                headers.put("Authentication", httpConfig.getAuthentication());
                headers.put("action", sendMsgAction);
                headers.put("serialNo", sealedMessage.getHeader().getPayLoadId());

                HttpUtil.ResponseCus responseCus = HttpUtil.doPostJsonEntire(httpConfig.getUrl(), JacksonUtil.getInstance().toJson(msgMap), headers, null);
                if (responseCus != null && responseCus.getStatus() == HttpStatus.SC_OK && StringUtils.isNotBlank(responseCus.getBody())) {
                    Map<String, Object> resp = JacksonUtil.getInstance().fromJson(responseCus.getBody(), Map.class);
                    if (resp != null && "1".equals(resp.get("code"))) {
                        log.info("发送消息businessNo:{}成功 msgId:{}", sealedMessage.getHeader().getPayLoadId(), resp.get("result"));
                        return true;
                    }
                }

                return false;
            } else {
                NettyTCPClient.getInstance().sendMessage(sealedMessage);
                result = true;
                return result;
            }
        }
    }

    public String getProperty(String key) {
        return (String) JanusClientProperties.getVal(key, "");
    }

    public boolean isAutoAck() {
        return autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        MCFactory.autoAck = autoAck;
    }

    public void close() {
        NettyTCPClient.getInstance().closeChannel();
        this.removeListener();
        SealedMessageCache.stop();
        ApolloThreadPool.getInstance().shutDown();
    }
}
