package com.xforceplus.janus.framework.dto;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;

/**
 * @Author: xuchuanhou
 * @Date:2022/4/8下午4:11
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
public class RecordPageParam extends PageParam {
    public static final String STATUS_FALIED="-1";
    public static final String STATUS_ALL="1";


    private String serialNo;
    private String action;
    private String requestTime;
    /** 200 成功 其他失败*/
    private String status;

    /**查询条件区间 yyyy-MM-dd HH:mm:ss*/
    private String beginDateTime;
    private String endDateTime;

    /**是否使用like 查询*/
    public boolean getIsLike() {
        if (StringUtils.isNotBlank(serialNo) && serialNo.length() > 5) {
            return true;
        }
        return false;

    }
}
