package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.janus.framework.event.dto.PullReceiptDto;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2023/11/20下午4:52
 */
@Slf4j
public class HttpAckServiceImpl implements AckService {


    @Override
    public void sendAck(SealedMessage sealedMessage, AckTuple<Boolean, String> ackTuple) {
        PullReceiptDto receiptDto = new PullReceiptDto(sealedMessage,ackTuple.status,ackTuple.getMessage());
        PullMsgBatchAckThread.sendAck(receiptDto);
    }
}
