package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Map;


public class HttpSendMsgConfigHandler implements ConfigHandler {
    @Override
    public void doHandler(String body) {
        if (StringUtils.isBlank(body)) {
            MCFactory.eventActionMap.clear();
            return;
        }
        Map<String, String> eventActionMapping = JacksonUtil.getInstance().fromJson(body, Map.class);
        if (MapUtils.isEmpty(eventActionMapping)) {
            MCFactory.eventActionMap.clear();
        } else {
            MCFactory.eventActionMap.putAll(eventActionMapping);
        }
    }

    @Override
    public String getConfigKey() {
        return "sendMsgByHttpEventMapping";
    }
}
