package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.framework.event.dto.BigDataTmpDto;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;

import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.context.ApplicationEventPublisher;

import java.io.File;
import java.util.Date;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.PreDestroy;

@Slf4j
public class InternalListener implements IMessageListener {

    private ApplicationEventPublisher eventPublisher;


    @Setter
    private BigDataTmpRepository bigDataTmpRepository;

    public InternalListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Override
    public boolean onMessage(SealedMessage sealedMessage) {
        SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, sealedMessage);
        if (sealedMessage.getHeader().getOthers().containsKey(Constant.FIELD_BIG_DATA_TASK_ID)) {
            //大报文拆分处理
            dealBigData(sealedMessage);
        } else {
            eventPublisher.publishEvent(sealedMessageEvent);
            log.info("业务代码:{} ID:{}:事件发送完成", sealedMessage.getHeader().getPayLoadId(), sealedMessage.getHeader().getMsgId());
        }
        return true;
    }


    /**
     * 大报文-未接收完整则保存入库，接收完整则数据组装后消息发送到业务处理模块
     *
     * @param
     * @return
     * @author xucuanhou
     * @date 2023/6/29
     */
    private void dealBigData(SealedMessage sealedMessage) {
        String taskId = sealedMessage.getHeader().getOthers().get(Constant.FIELD_BIG_DATA_TASK_ID);
        int splitCount = Integer.valueOf(sealedMessage.getHeader().getOthers().get(Constant.FIELD_BIG_DATA_COUNT));
        int splitIndex = Integer.valueOf(sealedMessage.getHeader().getOthers().get(Constant.FIELD_BIG_DATA_INDEX));
        String body = sealedMessage.getPayload().getObj().toString();
        BigRequestTmpDto requestBody = new BigRequestTmpDto(taskId, splitIndex, body, DateFormatUtils.format(new Date(), "yyyyMMddHHmmss"));

        try {
            BigRequestTmpDto existOne = bigDataTmpRepository.queryOne(taskId, splitIndex);
            if (existOne == null) {
                bigDataTmpRepository.saveBigDataTmp(requestBody);
            }

        } catch (Exception ex) {
            log.error("大报文片段保存失败:taskId:{},index:{}", taskId, splitIndex);
        }
        //最后一条
        if (splitIndex == (splitCount - 1)) {
            BigDataTmpDto bigDataTmpDto = new BigDataTmpDto();
            bigDataTmpDto.setTaskId(taskId);
            bigDataTmpDto.setSplitCount(splitCount);
            bigDataTmpDto.setHeader(JacksonUtil.getInstance().toJson(sealedMessage.getHeader()));
            BigDataDispatcher.BIG_DATA_TMP_QUEUE.offer(bigDataTmpDto);
        }
        return;

    }

    @PreDestroy
    public void preDestroy() {
        try {
            //释放资源
            String filePath = this.getClass().getName().replace(".", File.separator) + ".class";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }catch (Exception e){
            log.error("preDestroy:error:{}", ErrorUtil.getStackMsg(e));
        }catch (Error error){
            log.error("preDestroy:error:{}", ErrorUtil.getStackMsg(error));
        }
    }
}
