package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.config.core.util.SpringContextUtils;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import com.xforceplus.janus.framework.util.MyFileUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2023/6/29下午2:29
 */
public class McFactoryExter {

    private static final int eachSize = 102400;


    private static BigDataTmpRepository bigDataTmpRepository;

    public static synchronized boolean sendMessage(SealedMessage sealedMessage) throws Exception {
        String payload_str = null;
        if (sealedMessage.getPayload().getObj() instanceof String) {
            payload_str = sealedMessage.getPayload().getObj().toString();
        } else {
            payload_str = JacksonUtil.getInstance().toJson(sealedMessage.getPayload().getObj());
            sealedMessage.getHeader().getOthers().put("clazzName", sealedMessage.getPayload().getObj().getClass().getName());
        }
        //判断是否发送文件，本地文件则直接读取
        String inputFile = sealedMessage.getHeader().getOthers().get(MyFileUtils.TRANSFER_FILE_KEY);
        if (StringUtils.isNotBlank(inputFile)) {
            File file = new File(inputFile);
            if (!file.isFile() || !file.exists()) {
                return false;
            }
            String fileName = file.getName();
            sealedMessage.getHeader().getOthers().put(MyFileUtils.TRANSFER_FILE_NAME, fileName);
            String taskId = UniqIdUtils.getInstance().getUniqID();
            long sizeInBytes = file.length();
            long mod = sizeInBytes % eachSize;
            long count = mod == 0 ? sizeInBytes / eachSize : (sizeInBytes / eachSize) + 1;
            try (InputStream inputStream = Files.newInputStream(Paths.get(inputFile))) {
                byte[] buffer = new byte[eachSize];
                int bytesRead;
                int offset = 0;
                int i = 0;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                    int length = Math.min(eachSize, byteArrayOutputStream.toByteArray().length);
                    byte[] chunk = new byte[length];
                    System.arraycopy(byteArrayOutputStream.toByteArray(), offset, chunk, 0, length);
                    // 将字节数组编码为Base64字符串
                    String chunkString = Base64.getEncoder().encodeToString(chunk);
                    Map<String,String> others=new HashMap<>();
                    if(MapUtils.isNotEmpty(sealedMessage.getHeader().getOthers())){
                        others.putAll(sealedMessage.getHeader().getOthers());
                    }
                    String payLoadId = sealedMessage.getHeader().getPayLoadId()+"_"+i;
                    others.put("payLoadId",payLoadId);

                    SealedMessage.Header header =new SealedMessage.Header(sealedMessage.getHeader().getUserId(),sealedMessage.getHeader().getRequestName(), others);
                    SealedMessage splitMsg = new SealedMessage(header, new SealedMessage.Payload(chunkString));
                    splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_TASK_ID, taskId);
                    splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_INDEX, "" + i);
                    splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_COUNT, "" + count);
                    splitMsg.getHeader().getOthers().remove("clazzName");

                    splitMsg.getHeader().getOthers().put("beforeSplitMsgId", sealedMessage.getHeader().getMsgId());
                    //保存入库
                    BigRequestTmpDto bigMsg = new BigRequestTmpDto(taskId, i, chunkString, DateFormatUtils.format(new Date(), "yyyyMMddHHmmss"));
                    if(bigDataTmpRepository==null){
                        bigDataTmpRepository= SpringContextUtils.getBean(BigDataTmpRepository.class);
                    }
                    if (bigDataTmpRepository != null) {
                        bigDataTmpRepository.saveBigDataTmp(bigMsg);
                    }
                    MCFactory.getInstance().sendMessage(splitMsg);
                    i++;
                }
            }
            return true;

        } else {
            if (payload_str.length() > 102400) {
                byte[] btmp = FileBytesUtil.jzlib(payload_str.getBytes());
                String hexString = FileBytesUtil.bytesToHexString(btmp);
                if (StringUtils.isNotBlank(hexString) && hexString.length() > 524288) {
                    btmp = hexString.getBytes();
                    //大报文拆分
                    int mod = btmp.length % eachSize;
                    int count = mod == 0 ? btmp.length / eachSize : (btmp.length / eachSize) + 1;
                    String taskId = UniqIdUtils.getInstance().getUniqID();
                    for (int i = 0; i < count; i++) {

                        byte[] des = null;
                        if (mod == 0 || i < count - 1) {
                            des = new byte[eachSize];
                            System.arraycopy(btmp, eachSize * i, des, 0, eachSize);
                        } else {
                            des = new byte[mod];
                            System.arraycopy(btmp, eachSize * i, des, 0, mod);
                        }
                        String splitBody = new String(des);

                        Map<String,String> others=new HashMap<>();
                        if(MapUtils.isNotEmpty(sealedMessage.getHeader().getOthers())){
                            others.putAll(sealedMessage.getHeader().getOthers());
                        }
                        String payLoadId = sealedMessage.getHeader().getPayLoadId()+"_"+i;
                        others.put("payLoadId",payLoadId);

                        SealedMessage.Header header =new SealedMessage.Header(sealedMessage.getHeader().getUserId(),sealedMessage.getHeader().getRequestName(), others);
                        SealedMessage splitMsg = new SealedMessage(header, new SealedMessage.Payload(splitBody));
                        splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_TASK_ID, taskId);
                        splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_INDEX, "" + i);
                        splitMsg.getHeader().getOthers().put(Constant.FIELD_BIG_DATA_COUNT, "" + count);
                        splitMsg.getHeader().getOthers().remove("clazzName");

                        splitMsg.getHeader().getOthers().put("beforeSplitMsgId", sealedMessage.getHeader().getMsgId());
                        //保存入库
                        BigRequestTmpDto bigMsg = new BigRequestTmpDto(taskId, i, splitBody, DateFormatUtils.format(new Date(), "yyyyMMddHHmmss"));
                        if(bigDataTmpRepository==null){
                            bigDataTmpRepository= SpringContextUtils.getBean(BigDataTmpRepository.class);
                        }
                        if (bigDataTmpRepository != null) {
                            bigDataTmpRepository.saveBigDataTmp(bigMsg);
                        }

                        MCFactory.getInstance().sendMessage(splitMsg);
                    }
                    return true;
                }
            }
            return MCFactory.getInstance().sendMessage(sealedMessage);
        }
    }

}
