package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.ZipUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.event.dto.PullMsgClientDataDto;
import com.xforceplus.janus.framework.event.dto.PullMsgResultDto;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;
import org.springframework.context.ApplicationEventPublisher;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * 主动从集成平台拉取消息
 *
 * @Author: xuchuanhou
 * @Date:2023/11/20下午4:33
 */
@NoArgsConstructor
@Slf4j
public class MsgHttpConsumer implements Runnable {


    public static final String ACTION_HTTP_PULL = "action_msg_http_pull";
    public static AtomicBoolean running = new AtomicBoolean(false);

    private HttpConfig httpConfig;
    private ApplicationEventPublisher eventPublisher;

    public MsgHttpConsumer(HttpConfig httpConfig, ApplicationEventPublisher eventPublisher) {
        this.httpConfig = httpConfig;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void run() {
        running.set(true);
        while (true && running.get()) {
            try {
                Map<String, String> headers = new HashMap<>();
                headers.put("Authentication", httpConfig.getAuthentication());
                headers.put("action", HttpConfig.getConfig(ACTION_HTTP_PULL));
                headers.put(Constant.KEY_SERIALNO, "" + System.currentTimeMillis());
                JanusHttpUtil.ResponseCus reuslt = JanusHttpUtil.doGetEntire(httpConfig.getUrl(), null, true, headers);

                if (reuslt != null && HttpStatus.SC_OK == reuslt.getStatus() && StringUtils.isNotBlank(reuslt.getBody())) {
                    PullMsgResultDto pullResult = JacksonUtil.getInstance().fromJson(reuslt.getBody(), PullMsgResultDto.class);
                    if (pullResult != null && Constant.RESP_CODE_OK.equals(pullResult.getCode()) && CollectionUtils.isNotEmpty(pullResult.getResult())) {
                        for (String msg : pullResult.getResult()) {
                            String dealMsg = msg;
                            // 全局压缩需要先解压
                            if (Boolean.TRUE.toString().equals(pullResult.getBigDataCompress())) {
                                byte[] bytes = FileBytesUtil.hexStringToByte(msg);
                                byte[] oriBytes = FileBytesUtil.unjzlib(bytes);
                                if (null != oriBytes && oriBytes.length > 0) {
                                    dealMsg = new String(oriBytes);
                                }
                            }
                            SealedMessage sealedMessage = JacksonUtil.getInstance().fromJson(dealMsg, SealedMessage.class);

                            sealedMessage = ZipUtil.decompress(sealedMessage);
                            Optional.ofNullable(sealedMessage).ifPresent(m -> {
                                SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, m);
                                log.info("http pull msgId:{} ,payloadId:{}", m.getHeader().getMsgId(), m.getHeader().getPayLoadId());
                                eventPublisher.publishEvent(sealedMessageEvent);
                            });
                        }
                        continue;
                    }
                }

                TimeUnit.SECONDS.sleep(2);
            } catch (Throwable ex) {
                try {
                    log.error("http pull message error:{}", ex.getMessage());
                    TimeUnit.SECONDS.sleep(5);
                } catch (Throwable interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }


    private static final String KEY_PULL_MSG = "TCP_PULL";


    /**
     * 消息订阅是否http拉取模式
     */
    public static boolean isPullMsg() {
        String value = HttpConfig.getConfig(KEY_PULL_MSG);
        if (StringUtils.isBlank(value)) {
            return false;
        }

        PullMsgClientDataDto dataDto = JacksonUtil.getInstance().fromJson(value, PullMsgClientDataDto.class);
        if (dataDto != null && Boolean.TRUE.toString().equals(dataDto.getPull())) {
            return true;
        }
        return false;
    }

}
