package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.dto.ClientInfo;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;

import java.io.File;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/9下午4:59
 */
@Slf4j
@Order(0)
public class ProjectClientInitHandler implements ConfigHandler {

    @Setter
    private InternalListener messageListener;
    @Setter
    private HttpConfig httpConfig;
    @Setter
    private ApplicationEventPublisher eventPublisher;
    @Setter
    private SealedMessageEventBus sealedMessageEventBus;

    @Override
    public void doHandler(String body) {
        ClientInfo clientInfo = null;
        if (StringUtils.isNotBlank(body)) {
            //MCFactory 为空才创建
            clientInfo = JacksonUtil.getInstance().fromJson(body, ClientInfo.class);
            httpConfig.setClientInfo(body);
            httpConfig.setClientId(clientInfo.getClientId());
            httpConfig.setTcpUrl(clientInfo.getUrl());
            httpConfig.setTcpPort(clientInfo.getPort());
            if (StringUtils.isNotBlank(httpConfig.getTcpProxyHost())) {
                httpConfig.setTcpUrl(httpConfig.getTcpProxyHost());
            }
            if (httpConfig.getTcpProxyPort()>0) {
                httpConfig.setTcpPort(httpConfig.getTcpProxyPort());
            }
            MCFactory.setHttpConfig(httpConfig);
        } else {
            log.error("项目信息为空");
            return;
        }
        MCFactory mcFactory = null;
        try {
            mcFactory = MCFactory.getInstance();
        } catch (RuntimeException ex) {
            mcFactory = MCFactory.getInstance(httpConfig.getClientId(), httpConfig.getTcpUrl(), httpConfig.getTcpPort());
        }
        if (mcFactory == null) {
            throw new RuntimeException("client 初始化异常");
        }
        if (MsgHttpConsumer.isPullMsg()) {
            startHttpPullMsgMode();
            return;
        } else {
            sealedMessageEventBus.setAckService(new TcpAckServiceImpl());
        }
        if (messageListener != null) {
            String filePath = messageListener.getClass().getName().replace(".", File.separator) + ".class";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        mcFactory.registerListener(messageListener);
        /**从集成框架接入-关闭自动ack功能*/
        mcFactory.setAutoAck(false);

        return;
}

    private void startHttpPullMsgMode() {
        sealedMessageEventBus.setAckService(new HttpAckServiceImpl());
        //启动拉取消息和ack 线程
        if (!MsgHttpConsumer.running.get()) {
            new Thread(new MsgHttpConsumer(httpConfig, eventPublisher)).start();
        }

        if (!PullMsgBatchAckThread.running.get()) {
            new Thread(new PullMsgBatchAckThread(httpConfig)).start();
        }

    }

    @Override
    public String getConfigKey() {
        return "client";
    }
}
