package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.event.dto.PullReceiptDto;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2023/11/17下午1:37
 */
@Slf4j
@NoArgsConstructor
public class PullMsgBatchAckThread implements Runnable {

    public static BlockingQueue<PullReceiptDto> RECEIPTQUEUE = new ArrayBlockingQueue<>(5000);

    public static final String ACTION_ACK_PULL = "action_msg_http_ack";

    public static AtomicBoolean running = new AtomicBoolean(false);

    /*每次批量回执最大值*/
    private static final int MAX_BATCH_SIZE = 20;

    private HttpConfig httpConfig;


    public PullMsgBatchAckThread(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }


    public static boolean sendAck(PullReceiptDto receiptDto) {
        boolean result = RECEIPTQUEUE.offer(receiptDto);
        return result;
    }

    /**
     * 没有数据情况下5s 判断一次，间隔递增，最多间隔
     */
    @Override
    public void run() {
        List<PullReceiptDto> subList = new ArrayList<>();
        running.set(true);
        while (true && running.get()) {
            try {
                int size = RECEIPTQUEUE.drainTo(subList, MAX_BATCH_SIZE);
                if (size == 0) {
                    TimeUnit.SECONDS.sleep(5);
                    continue;
                }

                batchAck(subList);
                subList.clear();

            } catch (Exception ex) {
                log.error("处理 http 回执异常");
            }
        }
    }

    private void batchAck(List<PullReceiptDto> items) throws IOException {
        Map<String, String> headers = new HashMap<>();
        headers.put("Authentication", httpConfig.getAuthentication());
        headers.put("action", HttpConfig.getConfig(ACTION_ACK_PULL));
        headers.put(Constant.KEY_SERIALNO, "" + System.currentTimeMillis());

        Map<String, Object> body = new HashMap<>();
        body.put("receipts", items);
        int retryTimes = 5;
        boolean success = false;
        do {
            try {
                JanusHttpUtil.ResponseCus reuslt = JanusHttpUtil.doPostJsonEntire(httpConfig.getUrl(), JacksonUtil.getInstance().toJson(body), headers, null);
                if (reuslt != null && reuslt.getStatus() == HttpStatus.SC_OK && StringUtils.isNotBlank(reuslt.getBody())) {
                    Map<String, Object> ackResult = JacksonUtil.getInstance().fromJson(reuslt.getBody(), Map.class);
                    if (ackResult != null && Constant.RESP_CODE_OK.equals(ackResult.get("code"))) {
                        success = true;
                    }
                }
            } catch (Exception ex) {
                log.error("http send ack exception,{}", ex);
            }
            retryTimes--;
            if (!success) {
                try {
                    TimeUnit.SECONDS.sleep(2);
                } catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        } while (!success && retryTimes > 0);


    }


}
