package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.client.utils.SealedMessageBuilder;
import com.xforceplus.apollo.msg.SealedMessage;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2023/11/20下午4:50
 */
@Slf4j
public class TcpAckServiceImpl implements AckService {
    @Override
    public void sendAck(SealedMessage sealedMessage, AckTuple<Boolean, String> ackTuple) {
        try {
            MCFactory.getInstance().sendMessage(SealedMessageBuilder.buildReceiptMessage(sealedMessage, ackTuple.getStatus(), ackTuple.getMessage()));
        } catch (Exception e) {
            e.printStackTrace();
            log.error("发送回执异常:{}", e);
        }

    }
}
