package com.xforceplus.janus.framework.event.dto;

import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.msg.SealedMessage;

import org.apache.commons.lang3.StringUtils;

import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @Author: xuchuanhou
 * @Date:2023/11/20上午11:28
 */
@NoArgsConstructor
@Data
public class PullReceiptDto {

    public static final int MAX_REMARK_LENGTH = 1024;

    /**
     * @param msg 原始消息MSG
     * @return
     * @author xucuanhou
     * @date 2023/11/20
     */
    public PullReceiptDto(SealedMessage msg, boolean result, String remark) {
        this.requestName = msg.getHeader().getRequestName();
        this.msgId = msg.getHeader().getMsgId();
        this.providerId = msg.getHeader().getUserId();
        this.id = UniqIdUtils.getInstance().getUniqID();

        this.status = Boolean.toString(result);
        /**备注拦截*/
        if (StringUtils.isNotBlank(remark) && remark.length() > MAX_REMARK_LENGTH) {
            remark = remark.substring(0, MAX_REMARK_LENGTH);
        }
        this.remark = remark;

    }

    private String id;
    //消息发送方ID
    private String providerId;
    //消息ID
    private String msgId;
    //消息业务名
    private String requestName;
    //处理状态
    private String status = "true";
    //回执描述
    private String remark;
}
