package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import com.xforceplus.janus.framework.util.PageUtils;

import lombok.Setter;

/**
 * @Author: xuchuanhou
 * @Date:2022/4/8上午10:19
 */
@JanusCmdAnnotation(sourceType = QueryPageListCmdHandler.JANUS_CMD)
public class QueryPageListCmdHandler implements IJanusCmdHandler {

    public static final String JANUS_CMD = "listRequestRecordPage";

    @Setter
    JanusUploader janusUploader;

    @Setter
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        RecordPageParam param = JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), RecordPageParam.class);
        param.setAction(sealedMessage.getHeader().getOthers().get("businessType"));
        param.setRequestTime(sealedMessage.getHeader().getOthers().get("businessTime"));

        param.setBeginDateTime(sealedMessage.getHeader().getOthers().get("beginDate"));
        param.setEndDateTime(sealedMessage.getHeader().getOthers().get("endDate"));


        Result<Object> result = null;
        try {
            PageUtils page = accessRecordService.queryForPage(param);
            result = Result.ok(page);
        } catch (Exception exception) {
            result = new Result();
            result.setCode(Result.ResultCode.FAILED.getCode());
            result.setMessage(exception.getLocalizedMessage());
        }
        janusUploader.sendJanusCmdResult(sealedMessage.getHeader().getOthers().get("sourceType"), sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

//    @Override
//    public String getSourceType() {
//        return "listRequestRecordPage";
//    }
}
