package com.xforceplus.janus.framework.record.controller;

import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2023/7/4下午3:56
 */
@RestController
@RequestMapping("/bigdata")
public class BigDataController {

    @Autowired(required = false)
    private BigDataTmpRepository bigDataTmpRepository;

    /***
     *大报文查询块
     * @return
     */
    @GetMapping("blockinfo")
    public Map<String, Object> blockInfo(String taskId, @RequestParam(name="index") Integer index) {
        Map<String, Object> resultMap = new HashMap<>();
        BigRequestTmpDto bigRequestTmpDto = bigDataTmpRepository.queryOne(taskId, index);
        if (bigRequestTmpDto == null) {
            resultMap.put("code", "0");
            resultMap.put("message", "大报文块不存在");
        } else {
            resultMap.put("code", "1");
            resultMap.put("result", bigRequestTmpDto);
        }
        return resultMap;
    }


}
