package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/17下午5:44
 */
@Slf4j
public class BigDataTmpRepository {

    @Setter
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;

    private static final String insertSql = "insert into t_janus_big_request_tmp(task_id,task_index,content,created_time)values(:taskId,:taskIndex,:content,:createdTime)";

    public boolean saveBigDataTmp(BigRequestTmpDto requestBody) {
        Map param = BeanMapperUtil.map(requestBody, Map.class);
        int count = namedPrmtrJdbcTemplate.update(insertSql, param);
        return count == 1;
    }

    private static final String queryByTaskId = "select * from  t_janus_big_request_tmp where task_id=:taskId order by task_index";

    public List<BigRequestTmpDto> getByTaskId(String taskId) {
        return getByTaskId(taskId, true);
    }

    /***
     * 不查询报文
     * @param taskId
     * @param fullField 查询全部字段
     * @return
     */
    public List<BigRequestTmpDto> getByTaskId(String taskId, boolean fullField) {
        List<BigRequestTmpDto> acc = null;

        Map<String, String> param = new HashMap<String, String>() {{
            put("taskId", taskId);
        }};
        try {
            acc = namedPrmtrJdbcTemplate.query(queryByTaskId, param, new RowMapper<BigRequestTmpDto>() {
                @Override
                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    if (fullField) {
                        requestTmpDto.setContent(rs.getString("content"));
                    }
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));
                    return requestTmpDto;
                }
            });
        } catch (EmptyResultDataAccessException ex) {

        }
        return acc;
    }

    private static final String queryOne = "select * from  t_janus_big_request_tmp where task_id=:taskId and  task_index=:index";

    public BigRequestTmpDto queryOne(String taskId, Integer index) {
        List<BigRequestTmpDto> acc = null;

        Map<String, Object> param = new HashMap<String, Object>() {{
            put("taskId", taskId);
            put("index", index);
        }};
        try {
            acc = namedPrmtrJdbcTemplate.query(queryOne, param, new RowMapper<BigRequestTmpDto>() {
                @Override
                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    requestTmpDto.setContent(rs.getString("content"));
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));
                    return requestTmpDto;
                }
            });
        } catch (EmptyResultDataAccessException ex) {

        }

        return CollectionUtils.isEmpty(acc) ? null : acc.get(0);
    }


    private static final String SQL_COUNT_BT_TASKId = "select count(1) from  t_janus_big_request_tmp where task_id=:taskId";

    public int countByTaskId(String taskId) {

        Map<String, String> param = new HashMap<String, String>() {{
            put("taskId", taskId);
        }};
        List<Integer> counts = namedPrmtrJdbcTemplate.query(SQL_COUNT_BT_TASKId, param, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet resultSet, int i) throws SQLException {

                return resultSet.getInt(1);
            }
        });

        return CollectionUtils.isEmpty(counts) ? 0 : counts.get(0);
    }


}
