package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.utils.Base64Util;
import com.xforceplus.apollo.utils.code.GZipUtils;
import com.xforceplus.janus.config.core.util.Constant;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpStatus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;

import lombok.extern.slf4j.Slf4j;

/**
 * @Author: xuchuanhou
 * @Date:2022/5/27下午2:09
 */
@Slf4j
public class HttpUitls {

    private static final int SPLIT_MIN_SIZE = 1024000;

    private static final int eachSize = 512000;
    private static ExecutorService executorService = Executors.newFixedThreadPool(5);

    /**
     * 集成大报文压缩
     */
    public static JanusHttpUtil.ResponseCus doPostJsonEntire(String url, String json, Map<String, String> headers, Map<String, Object> params) throws IOException {

        if (headers == null) {
            headers = new HashMap<>();
        }

        if (json.length() < SPLIT_MIN_SIZE) {
            return JanusHttpUtil.doPostJsonEntire(url, json, headers, params);
        }

        byte[] btmp = GZipUtils.gzip(json);
        btmp = Base64Util.encode(btmp);

        int mod = btmp.length % eachSize;
        int count = mod == 0 ? btmp.length / eachSize : (btmp.length / eachSize) + 1;
        JanusHttpUtil.ResponseCus resp = null;
        String taskId = UniqIdUtils.getInstance().getUniqID();

        List<FutureTask> tasks = new ArrayList<>();

        for (int i = 0; i < count; i++) {

            byte[] des = null;
            if (mod == 0 || i < count - 1) {
                des = new byte[eachSize];
                System.arraycopy(btmp, eachSize * i, des, 0, eachSize);
            } else {
                des = new byte[mod];
                System.arraycopy(btmp, eachSize * i, des, 0, mod);
            }

            headers.put(Constant.FIELD_BIG_DATA_TASK_ID, taskId);
            headers.put(Constant.FIELD_BIG_DATA_INDEX, "" + i);
            headers.put(Constant.FIELD_BIG_DATA_COUNT, "" + count);
            if (!headers.containsKey(JanusHttpUtil.HEADER_KEY_CONTENT_TYPE)) {
                headers.put(JanusHttpUtil.HEADER_KEY_CONTENT_TYPE, "application/json");
            }

            Map<String, String> headerTmp = new HashMap<>();
            headerTmp.putAll(headers);
            byte[] bodyDes = des;

            FutureTask<Boolean> futureTask = new FutureTask<Boolean>(() -> {
                try {
                    int t = 5;
                    while (t > 0) {
                        JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(url, new String(bodyDes), headerTmp, params);
                        if (responseCus.getStatus() == HttpStatus.SC_OK) {
                            return true;
                        }
                        Thread.sleep(50);
                        t--;
                    }
                } catch (IOException e) {
                    log.error("上传分片请求失败");
                }
                return false;
            });
            tasks.add(futureTask);
            executorService.submit(futureTask);
        }

        try {
            int successCout = 0;
            for (FutureTask<Boolean> task : tasks) {
                try {
                    boolean suc = task.get(60, TimeUnit.SECONDS);
                    if (suc) {
                        successCout++;
                    }
                } catch (Exception ex) {
                    task.cancel(true);
                }
            }
            if (successCout == tasks.size()) {
                //发起真实调用
                headers.put(Constant.FIELD_BIG_DATA_TASK_ID, taskId);
                headers.remove(Constant.FIELD_BIG_DATA_INDEX);
                headers.put(Constant.FIELD_BIG_DATA_COUNT, "" + count);
                headers.put(Constant.FIELD_BIG_DATA_ONLY_INVOKE, "true");

                JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doPostJsonEntire(url, "{}", headers, params);
                if (responseCus.getStatus() == HttpStatus.SC_OK) {
                    return responseCus;
                }
                int retryTimes = 5;
                while (retryTimes > 0) {
                    if (responseCus != null && StringUtils.isNotBlank(responseCus.getBody()) && responseCus.getBody().contains("big-request-data-miss")) {
                        responseCus = JanusHttpUtil.doPostJsonEntire(url, "{}", headers, params);
                        if (responseCus.getStatus() == HttpStatus.SC_OK) {
                            return responseCus;
                        } else {
                            Thread.sleep(20);
                        }
                    } else {
                        return responseCus;
                    }
                    retryTimes--;
                }
            } else {
                resp = new JanusHttpUtil.ResponseCus(HttpStatus.SC_INTERNAL_SERVER_ERROR, "请求异常");
            }
        } catch (Exception ex) {
            resp = new JanusHttpUtil.ResponseCus(HttpStatus.SC_INTERNAL_SERVER_ERROR, "请求异常");
        } finally {
        }
        return resp;
    }

}
