package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.dto.LogFileDescribeCacheDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
@Slf4j
public class MyFileUtils {

    public static final String TRANSFER_FILE_KEY = "janus_transfer_file_url";
    public static final String TRANSFER_FILE_NAME = "janus_transfer_file_name";
    //将.gz文件解压为原始文件
   public static void writeUnGzip(String sourceFilePath, String targetFilePath) {
        FileOutputStream out = null;
        GZIPInputStream fis = null;
        try {
            fis = new GZIPInputStream(new FileInputStream(sourceFilePath));
            File target = new File(targetFilePath);
            out = new FileOutputStream(target);
            byte[] data = new byte[2097152];
            int count;
            while ((count = fis.read(data, 0, 2097152)) != -1) {
                out.write(data, 0, count);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (out != null) {
                    out.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }

    }

    public static LogFileDescribeCacheDto readCache(String fileName) {
        LogFileDescribeCacheDto dto = null;
        File file = new File(fileName);
        try {
            String cacheStr = FileUtils.readFileToString(file, "utf-8");
            if (StringUtils.isNotBlank(cacheStr)) {
                dto = JacksonUtil.getInstance().fromJson(cacheStr, LogFileDescribeCacheDto.class);
            }
        } catch (Exception e) {
            log.error(fileName + " 读取错误:" + ErrorUtil.getStackMsg(e));
        }
        if (dto == null) {
            dto = new LogFileDescribeCacheDto();
        }
        return dto;
    }

    public static void writeCache(String fileName, LogFileDescribeCacheDto dto) {
        File file = new File(fileName);
        try {
            FileUtils.writeStringToFile(file, JacksonUtil.getInstance().toJson(dto),"UTF-8");
        } catch (Exception var4) {
            log.error(fileName + " 写入失败:" + ErrorUtil.getStackMsg(var4));
        }

    }

    public static void copyFile(final File srcFile, final File destFile)  {
        try {
            FileUtils.copyFile(srcFile, destFile);
        } catch (Exception var4) {
            log.error( "copyFile 写入失败:" + ErrorUtil.getStackMsg(var4));
        }
    }
}
