package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.dto.JanusRequst;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

/**
 * @Author: xuchuanhou
 * @Date:2022/7/14下午4:14
 */
public class RequestUtil {

    public static JanusRequst readFromRequest(HttpServletRequest request) {
        JanusRequst janusRequst = new JanusRequst();

        Map<String, String> headerMap = new HashMap<>();
        Enumeration<String> headerEnu = request.getHeaderNames();
        while (headerEnu.hasMoreElements()) {
            String key = headerEnu.nextElement();
            headerMap.put(key, request.getHeader(key));
        }
        janusRequst.setHeaders(headerMap);

        Map<String, String> paramMap = new HashMap<>();
        Enumeration<String> paramEnu = request.getParameterNames();
        while (paramEnu.hasMoreElements()) {
            String key = paramEnu.nextElement();
            paramMap.put(key, request.getParameter(key));
        }
        janusRequst.setParams(paramMap);

        String reqBody = getRequestBody(request).toString();
        if (JacksonUtil.getInstance().isJsonArray(reqBody)) {
            janusRequst.setBody(JacksonUtil.getInstance().fromJsonToList(reqBody, Map.class));
        } else if (JacksonUtil.getInstance().isJson(reqBody)) {
            janusRequst.setBody(JacksonUtil.getInstance().fromJson(reqBody, Map.class));
        } else {
            janusRequst.setBody(reqBody);
        }

        return janusRequst;
    }

    public static StringBuilder getRequestBody(HttpServletRequest request) {
        StringBuilder requestBodySB = new StringBuilder();
        try (BufferedReader br = request.getReader()) {
            String line = null;
            while ((line = br.readLine()) != null) {
                requestBodySB.append(line);
            }
            br.close();
            return requestBodySB;
        } catch (IOException ex) {
        }

        return requestBodySB;
    }

}
