/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.apollo.client.netty;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.client.netty.JanusClientProperties;
import com.xforceplus.apollo.client.netty.NettyTCPClient;
import com.xforceplus.apollo.client.netty.ReceiveMessageThread;
import com.xforceplus.apollo.client.netty.SealedMessageCache;
import com.xforceplus.apollo.config.ClientConfig;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.pool.thread.ApolloThread;
import com.xforceplus.apollo.pool.thread.ApolloThreadInterface;
import com.xforceplus.apollo.pool.thread.ApolloThreadPool;
import com.xforceplus.apollo.utils.HttpUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.ZipUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.MsgHttpConsumer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MCFactory {
    private static final Logger log = LoggerFactory.getLogger(MCFactory.class);
    static volatile MCFactory instance = null;
    private static volatile boolean autoAck = true;
    static final ApolloThread[] receiveThreads = new ApolloThread[ClientConfig.getConfig().getIntProperty("receive.thread.num", Integer.valueOf(1)).intValue()];
    public static Map<String, String> eventActionMap = new HashMap<String, String>();
    private static HttpConfig httpConfig;

    private MCFactory() {
        SealedMessageCache.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MCFactory getInstance(String userId, String host, int port) {
        if (MsgHttpConsumer.isPullMsg()) {
            if (instance != null) return instance;
            Class<MCFactory> clazz = MCFactory.class;
            synchronized (MCFactory.class) {
                if (instance != null) return instance;
                instance = new MCFactory();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return instance;
            }
        }
        if (instance != null) return instance;
        Class<MCFactory> var3 = MCFactory.class;
        Class<MCFactory> clazz = MCFactory.class;
        synchronized (MCFactory.class) {
            if (instance != null) return instance;
            NettyTCPClient.getInstance((String)userId, (String)host, (int)port);
            for (int i = 0; i < receiveThreads.length; ++i) {
                ReceiveMessageThread apolloThread = new ReceiveMessageThread();
                apolloThread.setThreadName("receiveThread-" + i);
                log.info("\u542f\u52a8\u7ebf\u7a0b~~~~~~{}", (Object)apolloThread.getThreadName());
                MCFactory.receiveThreads[i] = apolloThread;
                ApolloThreadPool.getInstance().submit((ApolloThreadInterface)apolloThread);
            }
            instance = new MCFactory();
            // ** MonitorExit[var4_6] (shouldn't be in output)
            return instance;
        }
    }

    public static MCFactory getInstance() {
        if (instance == null) {
            throw new RuntimeException("\u8bf7\u5148\u6709\u53c2\u521d\u59cb\u5316...");
        }
        return instance;
    }

    public void registerListener(IMessageListener messageListener) {
        for (int i = 0; i < receiveThreads.length; ++i) {
            ((ReceiveMessageThread)receiveThreads[i]).registerListener(messageListener);
            log.info("\u6ce8\u518c\u6d88\u606f\u76d1\u542c~~~~~~{}", (Object)i);
        }
    }

    public void removeListener() {
        for (int i = 0; i < receiveThreads.length; ++i) {
            ((ReceiveMessageThread)receiveThreads[i]).removeListener();
            log.info("\u79fb\u9664\u6d88\u606f\u76d1\u542c~~~~~~{}", (Object)i);
        }
    }

    public synchronized boolean sendMessage(SealedMessage sealedMessage) throws Exception {
        boolean result = false;
        if (StringUtils.isBlank((CharSequence)sealedMessage.getHeader().getPayLoadId()) && StringUtils.isBlank((CharSequence)((CharSequence)sealedMessage.getHeader().getOthers().get("payLoadId")))) {
            throw new RuntimeException("\u4e1a\u52a1\u53f7payLoadId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String compressFlag = (String)sealedMessage.getHeader().getOthers().get("bigDataCompress");
        if (!(StringUtils.isNotBlank((CharSequence)compressFlag) && "true".equalsIgnoreCase(compressFlag) || null != (sealedMessage = ZipUtil.compress((SealedMessage)sealedMessage)))) {
            throw new Exception("\u538b\u7f29\u5f02\u5e38:\u6d88\u606f\u4f53\u8fc7\u5927\u6216\u5185\u5b58\u4e0d\u8db3");
        }
        if (MsgHttpConsumer.isPullMsg()) {
            Map resp;
            String sendMsgAction = eventActionMap.get(sealedMessage.getHeader().getRequestName());
            if (StringUtils.isBlank((CharSequence)sendMsgAction) && StringUtils.isBlank((CharSequence)(sendMsgAction = (String)HttpConfig.getConfig((String)"sendMsgAction")))) {
                log.error("\u6ca1\u6709\u53d1\u9001\u6d88\u606f{}\u6743\u9650", (Object)sealedMessage.getHeader().getRequestName());
                return false;
            }
            HashMap<String, Object> msgMap = new HashMap<String, Object>();
            msgMap.put("message", sealedMessage.getPayload().getObj().toString());
            msgMap.put("properties", sealedMessage.getHeader().getOthers());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authentication", httpConfig.getAuthentication());
            headers.put("action", sendMsgAction);
            headers.put("serialNo", sealedMessage.getHeader().getPayLoadId());
            HttpUtil.ResponseCus responseCus = HttpUtil.doPostJsonEntire((String)httpConfig.getUrl(), (String)JacksonUtil.getInstance().toJson(msgMap), headers, null);
            if (responseCus != null && responseCus.getStatus() == 200 && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && (resp = (Map)JacksonUtil.getInstance().fromJson(responseCus.getBody(), Map.class)) != null && "1".equals(resp.get("code"))) {
                log.info("\u53d1\u9001\u6d88\u606fbusinessNo:{}\u6210\u529f msgId:{}", (Object)sealedMessage.getHeader().getPayLoadId(), resp.get("result"));
                return true;
            }
            return false;
        }
        NettyTCPClient.getInstance().sendMessage(sealedMessage);
        result = true;
        return result;
    }

    public String getProperty(String key) {
        return (String)JanusClientProperties.getVal((String)key, (Object)"");
    }

    public boolean isAutoAck() {
        return autoAck;
    }

    public void setAutoAck(boolean autoAck) {
        MCFactory.autoAck = autoAck;
    }

    public void close() {
        NettyTCPClient.getInstance().closeChannel();
        this.removeListener();
        SealedMessageCache.stop();
        ApolloThreadPool.getInstance().shutDown();
    }

    public static void setHttpConfig(HttpConfig httpConfig) {
        MCFactory.httpConfig = httpConfig;
    }

    public static HttpConfig getHttpConfig() {
        return httpConfig;
    }
}

