/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.config;

import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.BigDataCommandLine;
import com.xforceplus.janus.framework.cmd.JanusCmdListener;
import com.xforceplus.janus.framework.cmd.SysCmdHandler;
import com.xforceplus.janus.framework.event.BigDataDispatcher;
import com.xforceplus.janus.framework.event.DefaultSealedMessageEventListener;
import com.xforceplus.janus.framework.event.EventInitListener;
import com.xforceplus.janus.framework.event.HttpSendMsgConfigHandler;
import com.xforceplus.janus.framework.event.InternalListener;
import com.xforceplus.janus.framework.event.ProjectClientInitHandler;
import com.xforceplus.janus.framework.event.SealedMessageEventBus;
import com.xforceplus.janus.framework.record.cmd.QueryPageListCmdHandler;
import com.xforceplus.janus.framework.record.cmd.RequestRecordDetailCmdHandler;
import com.xforceplus.janus.framework.record.cmd.RequestRetryCmdHandler;
import com.xforceplus.janus.framework.record.init.AccessRecordConsumerInit;
import com.xforceplus.janus.framework.record.init.ProjectCacheHandler;
import com.xforceplus.janus.framework.record.interceptor.BigRequestInterceptor;
import com.xforceplus.janus.framework.record.interceptor.RequestInterceptor;
import com.xforceplus.janus.framework.record.interceptor.WebFilter;
import com.xforceplus.janus.framework.record.interceptor.WebMvcConfig;
import com.xforceplus.janus.framework.record.portal.AccessContentRepository;
import com.xforceplus.janus.framework.record.portal.AccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.AccessRecordRepository;
import com.xforceplus.janus.framework.record.portal.AccessRecordServiceImpl;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import com.xforceplus.janus.framework.record.portal.DbAccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.LogAccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.RecordRetryHandler;
import com.xforceplus.janus.framework.record.portal.RestUrlUploader;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import java.util.Collections;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.Filter;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.context.WebApplicationContext;

@Configuration
public class CusConfiguration {
    public static final String TASK_EXECUTOR_NAME = "sealedEventTaskExecutor";
    private static final int QUEUE_SIZE = 50;

    @Bean
    public RequestInterceptor requestInterceptor(ProjectCacheHandler projectCacheHandler, HttpConfig httpConfig) {
        RequestInterceptor requestInterceptor = new RequestInterceptor();
        requestInterceptor.setProjectCacheHandler(projectCacheHandler);
        requestInterceptor.setHttpConfig(httpConfig);
        return requestInterceptor;
    }

    @ConditionalOnMissingBean(value={NamedParameterJdbcTemplate.class})
    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public NamedParameterJdbcTemplate namedParameterJdbcTemplate(DataSource dataSource) {
        NamedParameterJdbcTemplate template = new NamedParameterJdbcTemplate(dataSource);
        return template;
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public AccessRecordConsumer dbAccConsumer() {
        return new DbAccessRecordConsumer();
    }

    @Bean
    @ConditionalOnMissingBean(value={AccessRecordConsumer.class})
    public AccessRecordConsumer logAccConsumer() {
        return new LogAccessRecordConsumer();
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.webfilter", name={"enable"}, havingValue="true", matchIfMissing=true)
    FilterRegistrationBean<WebFilter> myFilterFilterRegistrationBean(HttpConfig config, ProjectCacheHandler projectCacheHandler) {
        FilterRegistrationBean filterRegist = new FilterRegistrationBean();
        WebFilter webFilter = new WebFilter();
        filterRegist.setFilter((Filter)webFilter);
        filterRegist.setOrder(-1);
        filterRegist.setUrlPatterns(Collections.singletonList("/*"));
        return filterRegist;
    }

    @Bean
    WebMvcConfig createWebMvcConfig(RequestInterceptor requestInterceptor, HttpConfig httpConfig, @Autowired(required=false) BigRequestInterceptor bigRequestInterceptor) {
        WebMvcConfig bean = new WebMvcConfig();
        bean.setRequestInterceptor(requestInterceptor);
        bean.setHttpConfig(httpConfig);
        bean.setBigRequestInterceptor(bigRequestInterceptor);
        return bean;
    }

    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    @Bean
    public AccessContentRepository accessContentRepository(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate, HttpConfig coreConfig) {
        AccessContentRepository accessContentRepository = new AccessContentRepository();
        accessContentRepository.setNamedPrmtrJdbcTemplate(namedPrmtrJdbcTemplate);
        accessContentRepository.setCoreConfig(coreConfig);
        return accessContentRepository;
    }

    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    @Bean
    public AccessRecordRepository accessRecordRepository(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate, HttpConfig coreConfig) {
        AccessRecordRepository accessRecordRepository = new AccessRecordRepository();
        accessRecordRepository.setNamedPrmtrJdbcTemplate(namedPrmtrJdbcTemplate);
        accessRecordRepository.setHttpConfig(coreConfig);
        return accessRecordRepository;
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public BigDataCommandLine createBigDataCmdLine(BigDataDispatcher bigDataDispatcher) {
        BigDataCommandLine bigDataCommandLine = new BigDataCommandLine();
        bigDataCommandLine.setBigDataDispatcher(bigDataDispatcher);
        return bigDataCommandLine;
    }

    @Bean
    @ConditionalOnMissingBean(value={AccessRecordService.class})
    public AccessRecordService accessRecordService(@Autowired(required=false) AccessRecordRepository accessRecordRepository, @Autowired(required=false) AccessContentRepository accessContentRepository, ServerProperties serverProperties, HttpConfig coreConfig) {
        AccessRecordServiceImpl accessRecordService = new AccessRecordServiceImpl();
        accessRecordService.setAccessRecordRepository(accessRecordRepository);
        accessRecordService.setAccessContentRepository(accessContentRepository);
        accessRecordService.setServerProperties(serverProperties);
        accessRecordService.setCoreConfig(coreConfig);
        return accessRecordService;
    }

    @Bean
    public RequestRetryCmdHandler requestRetryCmdHandler(JanusUploader janusUploader, AccessRecordService accessRecordService, @Autowired(required=false) RecordRetryHandler recordRetryHandler) {
        RequestRetryCmdHandler requestRetryCmdHandler = new RequestRetryCmdHandler();
        requestRetryCmdHandler.setJanusUploader(janusUploader);
        requestRetryCmdHandler.setAccessRecordService(accessRecordService);
        requestRetryCmdHandler.setRecordRetryHandler(recordRetryHandler);
        return requestRetryCmdHandler;
    }

    @Bean
    public RequestRecordDetailCmdHandler requestRecordDetailHd(JanusUploader janusUploader, AccessRecordService accessRecordService) {
        RequestRecordDetailCmdHandler requestRecordDetailHd = new RequestRecordDetailCmdHandler();
        requestRecordDetailHd.setJanusUploader(janusUploader);
        requestRecordDetailHd.setAccessRecordService(accessRecordService);
        return requestRecordDetailHd;
    }

    @Bean
    public QueryPageListCmdHandler queryPageListCmdHandler(JanusUploader janusUploader, AccessRecordService accessRecordService) {
        QueryPageListCmdHandler queryPageListCmdHandler = new QueryPageListCmdHandler();
        queryPageListCmdHandler.setJanusUploader(janusUploader);
        queryPageListCmdHandler.setAccessRecordService(accessRecordService);
        return queryPageListCmdHandler;
    }

    @Bean
    public ProjectCacheHandler projectCacheHandler() {
        ProjectCacheHandler projectHandler = new ProjectCacheHandler();
        return projectHandler;
    }

    @Bean
    public RestUrlUploader autoMappingUploader(WebApplicationContext webApplicationContext) {
        RestUrlUploader urlMappingLoader = new RestUrlUploader();
        urlMappingLoader.setWebApplicationContext(webApplicationContext);
        return urlMappingLoader;
    }

    @Bean
    public AccessRecordConsumerInit accessStarter(AccessRecordConsumer accessRecordConsumer, RestUrlUploader restUrlUploader, HttpConfig httpConfig, JanusUploader janusUploader) {
        AccessRecordConsumerInit accessStarter = new AccessRecordConsumerInit();
        accessStarter.setHttpConfig(httpConfig);
        accessStarter.setAccessRecordConsumer(accessRecordConsumer);
        accessStarter.setRestUrlUploader(restUrlUploader);
        accessStarter.setJanusUploader(janusUploader);
        return accessStarter;
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public BigDataTmpRepository bigDataTmpRepository(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate) {
        BigDataTmpRepository bigDataTmpRepository = new BigDataTmpRepository();
        bigDataTmpRepository.setNamedPrmtrJdbcTemplate(namedPrmtrJdbcTemplate);
        return bigDataTmpRepository;
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public BigRequestInterceptor bigDataRequest(BigDataTmpRepository bigDataTmpRepository) {
        BigRequestInterceptor bigRequestInterceptor = new BigRequestInterceptor();
        bigRequestInterceptor.setBigDataTmpRepository(bigDataTmpRepository);
        return bigRequestInterceptor;
    }

    @Bean
    public InternalListener internalListener(@Autowired ApplicationEventPublisher eventPublisher, @Autowired(required=false) BigDataTmpRepository bigDataTmpRepository) {
        InternalListener internalListener = new InternalListener(eventPublisher);
        internalListener.setBigDataTmpRepository(bigDataTmpRepository);
        return internalListener;
    }

    @DependsOn(value={"internalListener,sealedMessageEventBus,eventInitListener"})
    @Bean
    public ProjectClientInitHandler projectClientInitHandler(InternalListener internalListener, HttpConfig httpConfig, SealedMessageEventBus eventBus, ApplicationEventPublisher eventPublisher) {
        ProjectClientInitHandler projectClientInitHandler = new ProjectClientInitHandler();
        projectClientInitHandler.setMessageListener(internalListener);
        projectClientInitHandler.setHttpConfig(httpConfig);
        projectClientInitHandler.setSealedMessageEventBus(eventBus);
        projectClientInitHandler.setEventPublisher(eventPublisher);
        return projectClientInitHandler;
    }

    @Bean
    public EventInitListener eventInitListener() {
        EventInitListener eventInit = new EventInitListener();
        return eventInit;
    }

    @Bean
    public DefaultSealedMessageEventListener defaultSealedMessageEventListener() {
        DefaultSealedMessageEventListener messageEventBus = new DefaultSealedMessageEventListener();
        return messageEventBus;
    }

    @Bean
    public SealedMessageEventBus sealedMessageEventBus(DefaultSealedMessageEventListener defaultSealedMessageEventListener) {
        SealedMessageEventBus messageEventBus = new SealedMessageEventBus();
        messageEventBus.setDefaultSealedMessageEventListener(defaultSealedMessageEventListener);
        return messageEventBus;
    }

    @Bean
    public JanusCmdListener janusCmdListener() {
        JanusCmdListener janusCmdListener = new JanusCmdListener();
        return janusCmdListener;
    }

    @Bean
    public SysCmdHandler createSysCmdHander(JanusUploader janusUploader, HttpConfig httpConfig) {
        SysCmdHandler sysCmdHandler = new SysCmdHandler();
        sysCmdHandler.setJanusUploader(janusUploader);
        sysCmdHandler.setHttpConfig(httpConfig);
        return sysCmdHandler;
    }

    @Bean
    public HttpSendMsgConfigHandler createHttpSendMsgHandler() {
        HttpSendMsgConfigHandler httpSendMsgConfigHandler = new HttpSendMsgConfigHandler();
        return httpSendMsgConfigHandler;
    }

    @Bean
    @ConditionalOnProperty(prefix="janus.access", name={"persist"}, havingValue="db")
    public BigDataDispatcher creatBigDataDispatcher(ApplicationEventPublisher eventPublisher, BigDataTmpRepository bigDataTmpRepository, HttpConfig httpConfig) {
        BigDataDispatcher bigDataDispatcher = new BigDataDispatcher();
        bigDataDispatcher.setEventPublisher(eventPublisher);
        bigDataDispatcher.setBigDataTmpRepository(bigDataTmpRepository);
        bigDataDispatcher.setHttpConfig(httpConfig);
        return bigDataDispatcher;
    }

    @Bean(value={"sealedEventTaskExecutor"})
    public AsyncTaskExecutor getAsyncExecutor(HttpConfig httpConfig) {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        if (httpConfig.getThreadnum() <= 0) {
            httpConfig.setThreadnum(10);
        }
        executor.setCorePoolSize(httpConfig.getThreadnum());
        executor.setMaxPoolSize(httpConfig.getThreadnum());
        executor.setQueueCapacity(httpConfig.getPoolQueueSize() > 0 ? httpConfig.getPoolQueueSize() : 50);
        executor.setKeepAliveSeconds(60);
        executor.setThreadNamePrefix("sealedEventAsyncExecutor-");
        executor.setWaitForTasksToCompleteOnShutdown(true);
        executor.setAwaitTerminationSeconds(60);
        executor.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
        executor.initialize();
        return executor;
    }
}

