/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.dto;

import com.xforceplus.janus.framework.dto.LogFileDescribeDto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class LogFileDescribeCacheDto {
    private Map<String, List<LogFileDescribeDto>> dateFileMap = new HashMap<String, List<LogFileDescribeDto>>(16);
    private Map<String, LogFileDescribeDto> logFileMap = new HashMap<String, LogFileDescribeDto>(16);
    private Map<String, String> dec2SrcMap = new HashMap<String, String>(16);

    public List<LogFileDescribeDto> listLogFileByDateTime(String day) {
        return this.dateFileMap.get(day);
    }

    public LogFileDescribeDto getTargetFile(String fileFullPath) {
        return this.logFileMap.get(fileFullPath);
    }

    public Map<String, LogFileDescribeDto> getlogFileMap() {
        return this.logFileMap;
    }

    public LogFileDescribeDto putTargetFile(String fileFullPath, LogFileDescribeDto logFileDescribeDto) {
        this.logFileMap.put(fileFullPath, logFileDescribeDto);
        this.dec2SrcMap.put(logFileDescribeDto.getLogFileFullPath(), fileFullPath);
        List<String> dateTimes = logFileDescribeDto.getDateTimes();
        if (CollectionUtils.isNotEmpty(dateTimes)) {
            for (String dateTime : dateTimes) {
                List<LogFileDescribeDto> files = this.dateFileMap.get(dateTime);
                if (CollectionUtils.isEmpty(files)) {
                    files = new ArrayList<LogFileDescribeDto>();
                }
                boolean cantain = false;
                for (LogFileDescribeDto dto : files) {
                    if (!dto.getLogFileFullPath().equals(logFileDescribeDto)) continue;
                    cantain = true;
                    break;
                }
                if (!cantain) {
                    files.add(logFileDescribeDto);
                    Collections.sort(files, (file1, file2) -> {
                        try {
                            long creationTime1 = file1.getCreationTime();
                            long lastModifiedTime1 = file1.getLastModifiedTime();
                            long creationTime2 = file1.getCreationTime();
                            long lastModifiedTime2 = file1.getLastModifiedTime();
                            if (lastModifiedTime2 != lastModifiedTime1) {
                                return lastModifiedTime2 - lastModifiedTime1 > 0L ? -1 : 1;
                            }
                            if (creationTime2 != creationTime1) {
                                return creationTime2 - creationTime1 > 0L ? -1 : 1;
                            }
                            return file2.getLogFileFullPath().compareTo(file1.getLogFileFullPath());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            return file2.getLogFileFullPath().compareTo(file1.getLogFileFullPath());
                        }
                    });
                }
                this.dateFileMap.put(dateTime, files);
            }
        }
        return logFileDescribeDto;
    }

    public Map<String, List<LogFileDescribeDto>> getDateFileMap() {
        return this.dateFileMap;
    }

    public Map<String, String> getDec2SrcMap() {
        return this.dec2SrcMap;
    }

    public void setDateFileMap(Map<String, List<LogFileDescribeDto>> dateFileMap) {
        this.dateFileMap = dateFileMap;
    }

    public void setLogFileMap(Map<String, LogFileDescribeDto> logFileMap) {
        this.logFileMap = logFileMap;
    }

    public void setDec2SrcMap(Map<String, String> dec2SrcMap) {
        this.dec2SrcMap = dec2SrcMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogFileDescribeCacheDto)) {
            return false;
        }
        LogFileDescribeCacheDto other = (LogFileDescribeCacheDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<LogFileDescribeDto>> this$dateFileMap = this.getDateFileMap();
        Map<String, List<LogFileDescribeDto>> other$dateFileMap = other.getDateFileMap();
        if (this$dateFileMap == null ? other$dateFileMap != null : !((Object)this$dateFileMap).equals(other$dateFileMap)) {
            return false;
        }
        Map<String, LogFileDescribeDto> this$logFileMap = this.getlogFileMap();
        Map<String, LogFileDescribeDto> other$logFileMap = other.getlogFileMap();
        if (this$logFileMap == null ? other$logFileMap != null : !((Object)this$logFileMap).equals(other$logFileMap)) {
            return false;
        }
        Map<String, String> this$dec2SrcMap = this.getDec2SrcMap();
        Map<String, String> other$dec2SrcMap = other.getDec2SrcMap();
        return !(this$dec2SrcMap == null ? other$dec2SrcMap != null : !((Object)this$dec2SrcMap).equals(other$dec2SrcMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogFileDescribeCacheDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<LogFileDescribeDto>> $dateFileMap = this.getDateFileMap();
        result = result * 59 + ($dateFileMap == null ? 43 : ((Object)$dateFileMap).hashCode());
        Map<String, LogFileDescribeDto> $logFileMap = this.getlogFileMap();
        result = result * 59 + ($logFileMap == null ? 43 : ((Object)$logFileMap).hashCode());
        Map<String, String> $dec2SrcMap = this.getDec2SrcMap();
        result = result * 59 + ($dec2SrcMap == null ? 43 : ((Object)$dec2SrcMap).hashCode());
        return result;
    }

    public String toString() {
        return "LogFileDescribeCacheDto(dateFileMap=" + this.getDateFileMap() + ", logFileMap=" + this.getlogFileMap() + ", dec2SrcMap=" + this.getDec2SrcMap() + ")";
    }
}

