/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.dto.BigDataTmpDto;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class BigDataDispatcher {
    private static final Logger log = LoggerFactory.getLogger(BigDataDispatcher.class);
    public static final BlockingQueue<BigDataTmpDto> BIG_DATA_TMP_QUEUE = new ArrayBlockingQueue<BigDataTmpDto>(1000);
    private ApplicationEventPublisher eventPublisher;
    private BigDataTmpRepository bigDataTmpRepository;
    private HttpConfig httpConfig;
    private static final int MAX_RETRY_TIMES = 100;

    public void run() {
        while (true) {
            try {
                while (true) {
                    BigDataTmpDto bigDataTmpDto;
                    if ((bigDataTmpDto = BIG_DATA_TMP_QUEUE.take()).getRetryTimes() > 100) {
                        continue;
                    }
                    int existCount = this.bigDataTmpRepository.countByTaskId(bigDataTmpDto.getTaskId());
                    if (bigDataTmpDto.getSplitCount() == existCount) {
                        this.buildAndSendMsg(bigDataTmpDto);
                        continue;
                    }
                    TimeUnit.SECONDS.sleep(1L);
                    List<BigRequestTmpDto> dataDetails = this.bigDataTmpRepository.getByTaskId(bigDataTmpDto.getTaskId(), false);
                    if (CollectionUtils.isEmpty(dataDetails)) {
                        bigDataTmpDto.setRetryTimes(bigDataTmpDto.getRetryTimes() + 1);
                        BIG_DATA_TMP_QUEUE.offer(bigDataTmpDto);
                        continue;
                    }
                    List existIndexs = dataDetails.stream().map(d -> d.getTaskIndex()).collect(Collectors.toList());
                    for (int i = 0; i < bigDataTmpDto.getSplitCount(); ++i) {
                        BigRequestTmpDto bigRequestTmpDto;
                        if (existIndexs.contains(i) || (bigRequestTmpDto = this.fetchBigData(bigDataTmpDto.getTaskId(), i)) == null) continue;
                        this.bigDataTmpRepository.saveBigDataTmp(bigRequestTmpDto);
                    }
                    existCount = this.bigDataTmpRepository.countByTaskId(bigDataTmpDto.getTaskId());
                    if (bigDataTmpDto.getSplitCount() == existCount) {
                        this.buildAndSendMsg(bigDataTmpDto);
                        continue;
                    }
                    bigDataTmpDto.setRetryTimes(bigDataTmpDto.getRetryTimes() + 1);
                    BIG_DATA_TMP_QUEUE.offer(bigDataTmpDto);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private void buildAndSendMsg(BigDataTmpDto bigDataTmpDto) {
        SealedMessage.Header header = (SealedMessage.Header)JacksonUtil.getInstance().fromJson(bigDataTmpDto.getHeader(), SealedMessage.Header.class);
        String fileName = (String)header.getOthers().get("janus_transfer_file_name");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            List<BigRequestTmpDto> dataDetails = this.bigDataTmpRepository.getByTaskId(bigDataTmpDto.getTaskId(), false);
            String bPath = "tempfile";
            File fb = new File(bPath);
            if (!fb.isDirectory() || !fb.exists()) {
                fb.mkdir();
            }
            String outputPath = bPath + File.separator + fileName;
            for (BigRequestTmpDto bigData : dataDetails) {
                BigRequestTmpDto tmpDto = this.bigDataTmpRepository.queryOne(bigData.getTaskId(), bigData.getTaskIndex());
                byte[] fileBytes = Base64.getDecoder().decode(tmpDto.getContent());
                try {
                    FileOutputStream outputStream = new FileOutputStream(outputPath, true);
                    Throwable throwable = null;
                    try {
                        ((OutputStream)outputStream).write(fileBytes);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (outputStream == null) continue;
                        if (throwable != null) {
                            try {
                                ((OutputStream)outputStream).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((OutputStream)outputStream).close();
                    }
                }
                catch (Exception e) {
                    log.error(ErrorUtil.getStackMsg((Exception)e));
                    return;
                }
            }
            SealedMessage realSealedMessage = new SealedMessage(header, new SealedMessage.Payload((Object)outputPath));
            SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, realSealedMessage);
            this.eventPublisher.publishEvent((ApplicationEvent)sealedMessageEvent);
        } else {
            List<BigRequestTmpDto> dataDetails = this.bigDataTmpRepository.getByTaskId(bigDataTmpDto.getTaskId());
            StringBuilder stringBuilder = new StringBuilder();
            dataDetails.forEach(bq -> stringBuilder.append(bq.getContent()));
            byte[] decodeChar = FileBytesUtil.hexStringToByte((String)stringBuilder.toString());
            byte[] ungzipBody = FileBytesUtil.unjzlib((byte[])decodeChar);
            String realBody = new String(ungzipBody);
            SealedMessage realSealedMessage = new SealedMessage(header, new SealedMessage.Payload((Object)realBody));
            SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, realSealedMessage);
            this.eventPublisher.publishEvent((ApplicationEvent)sealedMessageEvent);
            log.info("\u4e1a\u52a1\u4ee3\u7801:{} ID:{}:\u4e8b\u4ef6\u53d1\u9001\u5b8c\u6210", (Object)realSealedMessage.getHeader().getPayLoadId(), (Object)realSealedMessage.getHeader().getMsgId());
        }
    }

    private BigRequestTmpDto fetchBigData(String taskId, int index) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("action", this.httpConfig.getAction().get((Object)"fetchBigDataBlock"));
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("serialNo", taskId);
        headers.put("taskid", taskId);
        headers.put("index", "" + index);
        try {
            Map respMap;
            JanusHttpUtil.ResponseCus responseCus = JanusHttpUtil.doGetEntire((String)this.httpConfig.getUrl(), null, (boolean)true, headers);
            if (responseCus != null && responseCus.getStatus() == 200 && StringUtils.isNotBlank((CharSequence)responseCus.getBody()) && (respMap = (Map)JacksonUtil.getInstance().fromJson(responseCus.getBody(), Map.class)).get("result") != null) {
                return (BigRequestTmpDto)JacksonUtil.getInstance().fromJson(respMap.get("result").toString(), BigRequestTmpDto.class);
            }
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u5927\u62a5\u6587\u5206\u7247\u5f02\u5e38taskId:{},index:{},msg:{}", new Object[]{taskId, index, ex.getMessage()});
            return null;
        }
        return null;
    }

    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setBigDataTmpRepository(BigDataTmpRepository bigDataTmpRepository) {
        this.bigDataTmpRepository = bigDataTmpRepository;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

