/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.event.ISealedMessageEventListener;
import com.xforceplus.janus.framework.event.SealedMessageEventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class EventInitListener
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger log = LoggerFactory.getLogger(EventInitListener.class);
    public static ConcurrentHashMap<String, ISealedMessageEventListener> EVENT_HANDLERS = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, IJanusCmdHandler> JANUS_CMD_HANDLERS = new ConcurrentHashMap();

    public void register(String eventType, ISealedMessageEventListener sealedMessageEventListener) {
        if (StringUtils.isBlank((CharSequence)eventType)) {
            log.warn("SealedMessageEvent\u4e8b\u4ef6\u5904\u7406\u5668\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01\uff01\uff01");
        }
        if (EVENT_HANDLERS.containsKey(eventType)) {
            log.warn("{}\u7684SealedMessageEvent\u4e8b\u4ef6\u5904\u7406\u5668\u5df2\u5b58\u5728\uff0c\u5c06\u66ff\u6362\u6700\u65b0\u7684\u5904\u7406\u5668\uff01\uff01\uff01", (Object)eventType);
        }
        EVENT_HANDLERS.put(eventType, sealedMessageEventListener);
        log.info("{}\u7684SealedMessageEvent\u4e8b\u4ef6\u5904\u7406\u5668\u6ce8\u518c\u6210\u529f\uff01", (Object)eventType);
    }

    public void clear() {
        EVENT_HANDLERS.clear();
        log.warn("\u6240\u6709\u7684\u7684SealedMessageEvent\u4e8b\u4ef6\u5904\u7406\u5668\u5df2\u6ce8\u9500\uff01\uff01\uff01");
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map janusCmdHandlerMap;
        Map beans = event.getApplicationContext().getBeansWithAnnotation(SealedMessageEventListener.class);
        if (null != beans) {
            beans.forEach((k, v) -> {
                String requestName = v.getClass().getAnnotation(SealedMessageEventListener.class).requestName();
                this.register(requestName, (ISealedMessageEventListener)v);
            });
        }
        if (null != (janusCmdHandlerMap = event.getApplicationContext().getBeansWithAnnotation(JanusCmdAnnotation.class))) {
            janusCmdHandlerMap.forEach((k, v) -> {
                String sourceType = v.getClass().getAnnotation(JanusCmdAnnotation.class).sourceType();
                JANUS_CMD_HANDLERS.put(sourceType, (IJanusCmdHandler)v);
            });
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventInitListener)) {
            return false;
        }
        EventInitListener other = (EventInitListener)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventInitListener;
    }

    public int hashCode() {
        int result = 1;
        return result;
    }

    public String toString() {
        return "EventInitListener()";
    }
}

