/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.IMessageListener;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.event.BigDataDispatcher;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.dto.BigDataTmpDto;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import java.io.File;
import java.util.Date;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class InternalListener
implements IMessageListener {
    private static final Logger log = LoggerFactory.getLogger(InternalListener.class);
    private ApplicationEventPublisher eventPublisher;
    private BigDataTmpRepository bigDataTmpRepository;

    public InternalListener(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public boolean onMessage(SealedMessage sealedMessage) {
        SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, sealedMessage);
        if (sealedMessage.getHeader().getOthers().containsKey("big-data-split-task-id")) {
            this.dealBigData(sealedMessage);
        } else {
            this.eventPublisher.publishEvent((ApplicationEvent)sealedMessageEvent);
            log.info("\u4e1a\u52a1\u4ee3\u7801:{} ID:{}:\u4e8b\u4ef6\u53d1\u9001\u5b8c\u6210", (Object)sealedMessage.getHeader().getPayLoadId(), (Object)sealedMessage.getHeader().getMsgId());
        }
        return true;
    }

    private void dealBigData(SealedMessage sealedMessage) {
        String taskId = (String)sealedMessage.getHeader().getOthers().get("big-data-split-task-id");
        int splitCount = Integer.valueOf((String)sealedMessage.getHeader().getOthers().get("big-data-split-count"));
        int splitIndex = Integer.valueOf((String)sealedMessage.getHeader().getOthers().get("big-data-split-index"));
        String body = sealedMessage.getPayload().getObj().toString();
        BigRequestTmpDto requestBody = new BigRequestTmpDto(taskId, splitIndex, body, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
        try {
            BigRequestTmpDto existOne = this.bigDataTmpRepository.queryOne(taskId, splitIndex);
            if (existOne == null) {
                this.bigDataTmpRepository.saveBigDataTmp(requestBody);
            }
        }
        catch (Exception ex) {
            log.error("\u5927\u62a5\u6587\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25:taskId:{},index:{}", (Object)taskId, (Object)splitIndex);
        }
        if (splitIndex == splitCount - 1) {
            BigDataTmpDto bigDataTmpDto = new BigDataTmpDto();
            bigDataTmpDto.setTaskId(taskId);
            bigDataTmpDto.setSplitCount(splitCount);
            bigDataTmpDto.setHeader(JacksonUtil.getInstance().toJson((Object)sealedMessage.getHeader()));
            BigDataDispatcher.BIG_DATA_TMP_QUEUE.offer(bigDataTmpDto);
        }
    }

    @PreDestroy
    public void preDestroy() {
        try {
            String filePath = this.getClass().getName().replace(".", File.separator) + ".class";
            File file = new File(filePath);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            log.error("preDestroy:error:{}", (Object)ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error error) {
            log.error("preDestroy:error:{}", (Object)ErrorUtil.getStackMsg((Throwable)error));
        }
    }

    public void setBigDataTmpRepository(BigDataTmpRepository bigDataTmpRepository) {
        this.bigDataTmpRepository = bigDataTmpRepository;
    }
}

