/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.core.utils.UniqIdUtils;
import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.util.SpringContextUtils;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class McFactoryExter {
    private static final int eachSize = 102400;
    private static BigDataTmpRepository bigDataTmpRepository;

    public static synchronized boolean sendMessage(SealedMessage sealedMessage) throws Exception {
        byte[] btmp;
        String hexString;
        String payload_str = null;
        if (sealedMessage.getPayload().getObj() instanceof String) {
            payload_str = sealedMessage.getPayload().getObj().toString();
        } else {
            payload_str = JacksonUtil.getInstance().toJson(sealedMessage.getPayload().getObj());
            sealedMessage.getHeader().getOthers().put("clazzName", sealedMessage.getPayload().getObj().getClass().getName());
        }
        String inputFile = (String)sealedMessage.getHeader().getOthers().get("janus_transfer_file_url");
        if (StringUtils.isNotBlank((CharSequence)inputFile)) {
            File file = new File(inputFile);
            if (!file.isFile() || !file.exists()) {
                return false;
            }
            String fileName = file.getName();
            sealedMessage.getHeader().getOthers().put("janus_transfer_file_name", fileName);
            String taskId = UniqIdUtils.getInstance().getUniqID();
            long sizeInBytes = file.length();
            long mod = sizeInBytes % 102400L;
            long count = mod == 0L ? sizeInBytes / 102400L : sizeInBytes / 102400L + 1L;
            try (InputStream inputStream = Files.newInputStream(Paths.get(inputFile, new String[0]), new OpenOption[0]);){
                int bytesRead;
                byte[] buffer = new byte[102400];
                int offset = 0;
                int i = 0;
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream.write(buffer, 0, bytesRead);
                    int length = Math.min(102400, byteArrayOutputStream.toByteArray().length);
                    byte[] chunk = new byte[length];
                    System.arraycopy(byteArrayOutputStream.toByteArray(), offset, chunk, 0, length);
                    String chunkString = Base64.getEncoder().encodeToString(chunk);
                    HashMap<String, String> others = new HashMap<String, String>();
                    if (MapUtils.isNotEmpty((Map)sealedMessage.getHeader().getOthers())) {
                        others.putAll(sealedMessage.getHeader().getOthers());
                    }
                    String payLoadId = sealedMessage.getHeader().getPayLoadId() + "_" + i;
                    others.put("payLoadId", payLoadId);
                    SealedMessage.Header header = new SealedMessage.Header(sealedMessage.getHeader().getUserId(), sealedMessage.getHeader().getRequestName(), others);
                    SealedMessage splitMsg = new SealedMessage(header, new SealedMessage.Payload((Object)chunkString));
                    splitMsg.getHeader().getOthers().put("big-data-split-task-id", taskId);
                    splitMsg.getHeader().getOthers().put("big-data-split-index", "" + i);
                    splitMsg.getHeader().getOthers().put("big-data-split-count", "" + count);
                    splitMsg.getHeader().getOthers().remove("clazzName");
                    splitMsg.getHeader().getOthers().put("beforeSplitMsgId", sealedMessage.getHeader().getMsgId());
                    BigRequestTmpDto bigMsg = new BigRequestTmpDto(taskId, i, chunkString, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
                    if (bigDataTmpRepository == null) {
                        bigDataTmpRepository = (BigDataTmpRepository)SpringContextUtils.getBean(BigDataTmpRepository.class);
                    }
                    if (bigDataTmpRepository != null) {
                        bigDataTmpRepository.saveBigDataTmp(bigMsg);
                    }
                    MCFactory.getInstance().sendMessage(splitMsg);
                    ++i;
                }
            }
            return true;
        }
        if (payload_str.length() > 102400 && StringUtils.isNotBlank((CharSequence)(hexString = FileBytesUtil.bytesToHexString((byte[])(btmp = FileBytesUtil.jzlib((byte[])payload_str.getBytes()))))) && hexString.length() > 524288) {
            btmp = hexString.getBytes();
            int mod = btmp.length % 102400;
            int count = mod == 0 ? btmp.length / 102400 : btmp.length / 102400 + 1;
            String taskId = UniqIdUtils.getInstance().getUniqID();
            for (int i = 0; i < count; ++i) {
                byte[] des = null;
                if (mod == 0 || i < count - 1) {
                    des = new byte[102400];
                    System.arraycopy(btmp, 102400 * i, des, 0, 102400);
                } else {
                    des = new byte[mod];
                    System.arraycopy(btmp, 102400 * i, des, 0, mod);
                }
                String splitBody = new String(des);
                HashMap<String, String> others = new HashMap<String, String>();
                if (MapUtils.isNotEmpty((Map)sealedMessage.getHeader().getOthers())) {
                    others.putAll(sealedMessage.getHeader().getOthers());
                }
                String payLoadId = sealedMessage.getHeader().getPayLoadId() + "_" + i;
                others.put("payLoadId", payLoadId);
                SealedMessage.Header header = new SealedMessage.Header(sealedMessage.getHeader().getUserId(), sealedMessage.getHeader().getRequestName(), others);
                SealedMessage splitMsg = new SealedMessage(header, new SealedMessage.Payload((Object)splitBody));
                splitMsg.getHeader().getOthers().put("big-data-split-task-id", taskId);
                splitMsg.getHeader().getOthers().put("big-data-split-index", "" + i);
                splitMsg.getHeader().getOthers().put("big-data-split-count", "" + count);
                splitMsg.getHeader().getOthers().remove("clazzName");
                splitMsg.getHeader().getOthers().put("beforeSplitMsgId", sealedMessage.getHeader().getMsgId());
                BigRequestTmpDto bigMsg = new BigRequestTmpDto(taskId, i, splitBody, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
                if (bigDataTmpRepository == null) {
                    bigDataTmpRepository = (BigDataTmpRepository)SpringContextUtils.getBean(BigDataTmpRepository.class);
                }
                if (bigDataTmpRepository != null) {
                    bigDataTmpRepository.saveBigDataTmp(bigMsg);
                }
                MCFactory.getInstance().sendMessage(splitMsg);
            }
            return true;
        }
        return MCFactory.getInstance().sendMessage(sealedMessage);
    }
}

