/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.FileBytesUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.apollo.utils.ZipUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.event.SealedMessageEvent;
import com.xforceplus.janus.framework.event.dto.PullMsgClientDataDto;
import com.xforceplus.janus.framework.event.dto.PullMsgResultDto;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;

public class MsgHttpConsumer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MsgHttpConsumer.class);
    public static final String ACTION_HTTP_PULL = "action_msg_http_pull";
    public static AtomicBoolean running = new AtomicBoolean(false);
    private HttpConfig httpConfig;
    private ApplicationEventPublisher eventPublisher;
    private static final String KEY_PULL_MSG = "TCP_PULL";

    public MsgHttpConsumer(HttpConfig httpConfig, ApplicationEventPublisher eventPublisher) {
        this.httpConfig = httpConfig;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void run() {
        running.set(true);
        while (running.get()) {
            try {
                PullMsgResultDto pullResult;
                HashMap<String, Object> headers = new HashMap<String, Object>();
                headers.put("Authentication", this.httpConfig.getAuthentication());
                headers.put("action", HttpConfig.getConfig((String)ACTION_HTTP_PULL));
                headers.put("serialNo", "" + System.currentTimeMillis());
                JanusHttpUtil.ResponseCus reuslt = JanusHttpUtil.doGetEntire((String)this.httpConfig.getUrl(), null, (boolean)true, headers);
                if (reuslt != null && 200 == reuslt.getStatus() && StringUtils.isNotBlank((CharSequence)reuslt.getBody()) && (pullResult = (PullMsgResultDto)JacksonUtil.getInstance().fromJson(reuslt.getBody(), PullMsgResultDto.class)) != null && "1".equals(pullResult.getCode()) && CollectionUtils.isNotEmpty(pullResult.getResult())) {
                    Iterator<String> iterator = pullResult.getResult().iterator();
                    while (iterator.hasNext()) {
                        byte[] bytes;
                        byte[] oriBytes;
                        String msg;
                        String dealMsg = msg = iterator.next();
                        if (Boolean.TRUE.toString().equals(pullResult.getBigDataCompress()) && null != (oriBytes = FileBytesUtil.unjzlib((byte[])(bytes = FileBytesUtil.hexStringToByte((String)msg)))) && oriBytes.length > 0) {
                            dealMsg = new String(oriBytes);
                        }
                        SealedMessage sealedMessage = (SealedMessage)JacksonUtil.getInstance().fromJson(dealMsg, SealedMessage.class);
                        sealedMessage = ZipUtil.decompress((SealedMessage)sealedMessage);
                        Optional.ofNullable(sealedMessage).ifPresent(m -> {
                            SealedMessageEvent sealedMessageEvent = new SealedMessageEvent(this, (SealedMessage)m);
                            log.info("http pull msgId:{} ,payloadId:{}", (Object)m.getHeader().getMsgId(), (Object)m.getHeader().getPayLoadId());
                            this.eventPublisher.publishEvent((ApplicationEvent)sealedMessageEvent);
                        });
                    }
                    continue;
                }
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (Throwable ex) {
                try {
                    log.error("http pull message error:{}", (Object)ex.getMessage());
                    TimeUnit.SECONDS.sleep(5L);
                }
                catch (Throwable interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
        }
    }

    public static boolean isPullMsg() {
        String value = (String)HttpConfig.getConfig((String)KEY_PULL_MSG);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        PullMsgClientDataDto dataDto = (PullMsgClientDataDto)JacksonUtil.getInstance().fromJson(value, PullMsgClientDataDto.class);
        return dataDto != null && Boolean.TRUE.toString().equals(dataDto.getPull());
    }

    public MsgHttpConsumer() {
    }
}

