/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.client.netty.MCFactory;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.framework.event.HttpAckServiceImpl;
import com.xforceplus.janus.framework.event.InternalListener;
import com.xforceplus.janus.framework.event.MsgHttpConsumer;
import com.xforceplus.janus.framework.event.PullMsgBatchAckThread;
import com.xforceplus.janus.framework.event.SealedMessageEventBus;
import com.xforceplus.janus.framework.event.TcpAckServiceImpl;
import com.xforceplus.janus.framework.event.dto.ClientInfo;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class ProjectClientInitHandler
implements ConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(ProjectClientInitHandler.class);
    private InternalListener messageListener;
    private HttpConfig httpConfig;
    private ApplicationEventPublisher eventPublisher;
    private SealedMessageEventBus sealedMessageEventBus;

    public void doHandler(String body) {
        String filePath;
        File file;
        ClientInfo clientInfo = null;
        if (StringUtils.isNotBlank((CharSequence)body)) {
            clientInfo = (ClientInfo)JacksonUtil.getInstance().fromJson(body, ClientInfo.class);
            this.httpConfig.setClientInfo(body);
            this.httpConfig.setClientId(clientInfo.getClientId());
            this.httpConfig.setTcpUrl(clientInfo.getUrl());
            this.httpConfig.setTcpPort(clientInfo.getPort().intValue());
            if (StringUtils.isNotBlank((CharSequence)this.httpConfig.getTcpProxyHost())) {
                this.httpConfig.setTcpUrl(this.httpConfig.getTcpProxyHost());
            }
            if (this.httpConfig.getTcpProxyPort() > 0) {
                this.httpConfig.setTcpPort(this.httpConfig.getTcpProxyPort());
            }
        } else {
            log.error("\u9879\u76ee\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        MCFactory.setHttpConfig(this.httpConfig);
        MCFactory mcFactory = null;
        try {
            mcFactory = MCFactory.getInstance();
        }
        catch (RuntimeException ex) {
            mcFactory = MCFactory.getInstance(this.httpConfig.getClientId(), this.httpConfig.getTcpUrl(), this.httpConfig.getTcpPort());
        }
        if (mcFactory == null) {
            throw new RuntimeException("client \u521d\u59cb\u5316\u5f02\u5e38");
        }
        if (MsgHttpConsumer.isPullMsg()) {
            this.startHttpPullMsgMode();
            return;
        }
        this.sealedMessageEventBus.setAckService(new TcpAckServiceImpl());
        if (this.messageListener != null && (file = new File(filePath = this.messageListener.getClass().getName().replace(".", File.separator) + ".class")).exists()) {
            file.delete();
        }
        mcFactory.registerListener(this.messageListener);
        mcFactory.setAutoAck(false);
    }

    private void startHttpPullMsgMode() {
        this.sealedMessageEventBus.setAckService(new HttpAckServiceImpl());
        if (!MsgHttpConsumer.running.get()) {
            new Thread(new MsgHttpConsumer(this.httpConfig, this.eventPublisher)).start();
        }
        if (!PullMsgBatchAckThread.running.get()) {
            new Thread(new PullMsgBatchAckThread(this.httpConfig)).start();
        }
    }

    public String getConfigKey() {
        return "client";
    }

    public void setMessageListener(InternalListener messageListener) {
        this.messageListener = messageListener;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setEventPublisher(ApplicationEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setSealedMessageEventBus(SealedMessageEventBus sealedMessageEventBus) {
        this.sealedMessageEventBus = sealedMessageEventBus;
    }
}

