/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.event;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.event.dto.PullReceiptDto;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullMsgBatchAckThread
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PullMsgBatchAckThread.class);
    public static BlockingQueue<PullReceiptDto> RECEIPTQUEUE = new ArrayBlockingQueue<PullReceiptDto>(5000);
    public static final String ACTION_ACK_PULL = "action_msg_http_ack";
    public static AtomicBoolean running = new AtomicBoolean(false);
    private static final int MAX_BATCH_SIZE = 20;
    private HttpConfig httpConfig;

    public PullMsgBatchAckThread(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public static boolean sendAck(PullReceiptDto receiptDto) {
        boolean result = RECEIPTQUEUE.offer(receiptDto);
        return result;
    }

    @Override
    public void run() {
        ArrayList<PullReceiptDto> subList = new ArrayList<PullReceiptDto>();
        running.set(true);
        while (running.get()) {
            try {
                int size = RECEIPTQUEUE.drainTo(subList, 20);
                if (size == 0) {
                    TimeUnit.SECONDS.sleep(5L);
                    continue;
                }
                this.batchAck(subList);
                subList.clear();
            }
            catch (Exception ex) {
                log.error("\u5904\u7406 http \u56de\u6267\u5f02\u5e38");
            }
        }
    }

    private void batchAck(List<PullReceiptDto> items) throws IOException {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("action", HttpConfig.getConfig((String)ACTION_ACK_PULL));
        headers.put("serialNo", "" + System.currentTimeMillis());
        HashMap<String, List<PullReceiptDto>> body = new HashMap<String, List<PullReceiptDto>>();
        body.put("receipts", items);
        int retryTimes = 5;
        boolean success = false;
        do {
            try {
                Map ackResult;
                JanusHttpUtil.ResponseCus reuslt = JanusHttpUtil.doPostJsonEntire((String)this.httpConfig.getUrl(), (String)JacksonUtil.getInstance().toJson(body), headers, null);
                if (reuslt != null && reuslt.getStatus() == 200 && StringUtils.isNotBlank((CharSequence)reuslt.getBody()) && (ackResult = (Map)JacksonUtil.getInstance().fromJson(reuslt.getBody(), Map.class)) != null && "1".equals(ackResult.get("code"))) {
                    success = true;
                }
            }
            catch (Exception ex) {
                log.error("http send ack exception,{}", (Throwable)ex);
            }
            --retryTimes;
            if (success) continue;
            try {
                TimeUnit.SECONDS.sleep(2L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        } while (!success && retryTimes > 0);
    }

    public PullMsgBatchAckThread() {
    }
}

