/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.cache;

import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessRecordCache {
    private static final Logger log = LoggerFactory.getLogger(AccessRecordCache.class);
    private static final int size = 500;
    private static final BlockingQueue<AccessRecord> ACCESS_RECORDS = new ArrayBlockingQueue<AccessRecord>(500);
    private static JanusUploader monitorUploader;
    private static long lastMonitorTime;
    private static final int TAKE_BATCH_SIZE = 9;

    public static void pushRecord(AccessRecord record) throws InterruptedException {
        if (record == null) {
            return;
        }
        boolean result = ACCESS_RECORDS.offer(record);
        if (!result) {
            log.error("accessrecord queue is full ,quantity:{}", (Object)500);
        }
    }

    public static AccessRecord takeRecord() throws InterruptedException {
        return ACCESS_RECORDS.take();
    }

    public static List<AccessRecord> takeBatch() throws InterruptedException {
        ArrayList<AccessRecord> ackMsgs = new ArrayList<AccessRecord>();
        AccessRecord accessRecord = ACCESS_RECORDS.take();
        ACCESS_RECORDS.drainTo(ackMsgs, 9);
        ackMsgs.add(accessRecord);
        return ackMsgs;
    }

    static {
        lastMonitorTime = 0L;
    }
}

