/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.RecordPageParam;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import com.xforceplus.janus.framework.util.PageUtils;

@JanusCmdAnnotation(sourceType="listRequestRecordPage")
public class QueryPageListCmdHandler
implements IJanusCmdHandler {
    public static final String JANUS_CMD = "listRequestRecordPage";
    JanusUploader janusUploader;
    private AccessRecordService accessRecordService;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        RecordPageParam param = (RecordPageParam)JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), RecordPageParam.class);
        param.setAction((String)sealedMessage.getHeader().getOthers().get("businessType"));
        param.setRequestTime((String)sealedMessage.getHeader().getOthers().get("businessTime"));
        param.setBeginDateTime((String)sealedMessage.getHeader().getOthers().get("beginDate"));
        param.setEndDateTime((String)sealedMessage.getHeader().getOthers().get("endDate"));
        Result<Object> result = null;
        try {
            PageUtils page = this.accessRecordService.queryForPage(param);
            result = Result.ok(page);
        }
        catch (Exception exception) {
            result = new Result();
            result.setCode(Result.ResultCode.FAILED.getCode());
            result.setMessage(exception.getLocalizedMessage());
        }
        this.janusUploader.sendJanusCmdResult((String)sealedMessage.getHeader().getOthers().get("sourceType"), (String)sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    public void setJanusUploader(JanusUploader janusUploader) {
        this.janusUploader = janusUploader;
    }

    public void setAccessRecordService(AccessRecordService accessRecordService) {
        this.accessRecordService = accessRecordService;
    }
}

