/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.cmd;

import com.xforceplus.apollo.msg.SealedMessage;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.cmd.IJanusCmdHandler;
import com.xforceplus.janus.framework.cmd.JanusCmdAnnotation;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.RecordRetryHandler;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

@JanusCmdAnnotation(sourceType="addRequestReplayTask")
public class RequestRetryCmdHandler
implements IJanusCmdHandler {
    JanusUploader janusUploader;
    private AccessRecordService accessRecordService;
    private RecordRetryHandler recordRetryHandler;

    @Override
    public void doHandler(SealedMessage sealedMessage) {
        String requstTime = (String)sealedMessage.getHeader().getOthers().get("businessTime");
        String recordId = (String)sealedMessage.getHeader().getOthers().get("accessId");
        String retryUseLogStr = (String)sealedMessage.getHeader().getOthers().get("retryUseLog");
        boolean retryResult = false;
        boolean retryUseLog = StringUtils.isNotBlank((CharSequence)retryUseLogStr) && "true".equals(retryUseLogStr);
        AccessRecord record = null;
        if (!retryUseLog) {
            AccessContentDto cont;
            if (sealedMessage.getPayload().getObj() != null && (cont = (AccessContentDto)JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), AccessContentDto.class)) != null && MapUtils.isNotEmpty(cont.getRequestHeader())) {
                record = this.accessRecordService.getById(recordId, requstTime);
                record.setAccessContent(cont);
            }
            if (record == null) {
                record = this.accessRecordService.getRichRecord(recordId, requstTime);
            }
        } else if (sealedMessage.getPayload().getObj() != null) {
            Map map = (Map)JacksonUtil.getInstance().fromJson(sealedMessage.getPayload().getObj().toString(), Map.class);
            String requestMethod = (String)map.get("requestMethod");
            AccessRecord.AccessRecordBuilder builder = AccessRecord.builder().requestMethod(requestMethod);
            Map accessContentMap = (Map)map.get("accessContent");
            AccessContentDto accessContentDto = new AccessContentDto();
            accessContentDto.setRequestHeader((Map)accessContentMap.get("requestHeader"));
            accessContentDto.setRequestParam((Map)accessContentMap.get("requestParam"));
            if (accessContentMap.get("requestBody") != null) {
                accessContentDto.setRequestBody((String)accessContentMap.get("requestBody"));
            }
            record = builder.build();
            record.setAccessContent(accessContentDto);
        }
        Result<Object> result = null;
        if (record == null) {
            result = new Result(Result.ResultCode.FAILED);
            result.setMessage("\u8bf7\u6c42\u5c65\u5386\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u91cd\u63a8");
        } else {
            retryResult = retryUseLog ? this.accessRecordService.retryAccessRecord(record) : (this.recordRetryHandler != null ? this.recordRetryHandler.retry(record) : this.accessRecordService.retryAccessRecord(recordId, requstTime));
        }
        result = retryResult ? new Result<Boolean>(retryResult, Result.ResultCode.OK) : new Result<Boolean>(retryResult, Result.ResultCode.FAILED);
        this.janusUploader.sendJanusCmdResult((String)sealedMessage.getHeader().getOthers().get("sourceType"), (String)sealedMessage.getHeader().getOthers().get("cmdSerialKey"), result);
    }

    public void setJanusUploader(JanusUploader janusUploader) {
        this.janusUploader = janusUploader;
    }

    public void setAccessRecordService(AccessRecordService accessRecordService) {
        this.accessRecordService = accessRecordService;
    }

    public void setRecordRetryHandler(RecordRetryHandler recordRetryHandler) {
        this.recordRetryHandler = recordRetryHandler;
    }
}

