/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.init;

import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.framework.record.portal.AccessRecordConsumer;
import com.xforceplus.janus.framework.record.portal.RestUrlUploader;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.CommandLineRunner;

public class AccessRecordConsumerInit
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(AccessRecordConsumerInit.class);
    private AccessRecordConsumer accessRecordConsumer;
    private RestUrlUploader restUrlUploader;
    private HttpConfig httpConfig;
    private JanusUploader janusUploader;

    public void run(String ... args) throws Exception {
        List<Map<String, String>> urls;
        this.accessRecordConsumer.start();
        if (this.httpConfig.isUploadApi() && CollectionUtils.isNotEmpty(urls = this.restUrlUploader.getUrl())) {
            new Thread(() -> {
                HttpConfig httpConfig = this.httpConfig;
                synchronized (httpConfig) {
                    this.janusUploader.sendJanusCmdResult("uploadApis", "1", (Object)urls);
                }
            }).start();
        }
    }

    public void setAccessRecordConsumer(AccessRecordConsumer accessRecordConsumer) {
        this.accessRecordConsumer = accessRecordConsumer;
    }

    public void setRestUrlUploader(RestUrlUploader restUrlUploader) {
        this.restUrlUploader = restUrlUploader;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setJanusUploader(JanusUploader janusUploader) {
        this.janusUploader = janusUploader;
    }
}

