/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.init;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.ConfigHandler;
import com.xforceplus.janus.config.core.dto.ApiDto;
import com.xforceplus.janus.config.core.dto.ProjectDto;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;

@Order(value=0)
public class ProjectCacheHandler
implements ConfigHandler {
    private static final Logger log = LoggerFactory.getLogger(ProjectCacheHandler.class);
    private Map<String, ApiDto> apiCache = new ConcurrentHashMap<String, ApiDto>();
    private Map<String, String> httpDiyFlowCache = new ConcurrentHashMap<String, String>();

    public String getConfigKey() {
        return "projectInfo";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandler(String body) {
        if (StringUtils.isNotBlank((CharSequence)body)) {
            ProjectDto projectDto = (ProjectDto)JacksonUtil.getInstance().fromJson(body, ProjectDto.class);
            Map<String, ApiDto> map = this.apiCache;
            synchronized (map) {
                this.apiCache.clear();
                if (projectDto != null && CollectionUtils.isNotEmpty((Collection)projectDto.getApisEntities())) {
                    projectDto.getApisEntities().forEach(api -> this.apiCache.put(api.getRequestPath() + api.getRequestMethod(), (ApiDto)api));
                }
            }
        }
    }

    public void nullValueHandler() {
    }

    public Map<String, ApiDto> getApiCache() {
        return this.apiCache;
    }

    public Map<String, String> getHttpDiyFlowCache() {
        return this.httpDiyFlowCache;
    }
}

