/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import com.xforceplus.apollo.utils.Base64Util;
import com.xforceplus.apollo.utils.code.GZipUtils;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import com.xforceplus.janus.framework.record.interceptor.CustomHttpServletRequestWrapper;
import com.xforceplus.janus.framework.record.portal.BigDataTmpRepository;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class BigRequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(BigRequestInterceptor.class);
    private BigDataTmpRepository bigDataTmpRepository;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String taskId = request.getHeader("big-data-split-task-id");
        if (StringUtils.isNotBlank((CharSequence)taskId)) {
            int splitCount = Integer.valueOf(request.getHeader("big-data-split-count"));
            String onlyInvoke = request.getHeader("big-data-split-only-invoke");
            String body = null;
            if (request instanceof CustomHttpServletRequestWrapper) {
                body = this.getRequestBody((CustomHttpServletRequestWrapper)request).toString();
            }
            int existCount = this.bigDataTmpRepository.countByTaskId(taskId);
            if (Boolean.TRUE.toString().equals(onlyInvoke)) {
                if (existCount == splitCount) {
                    List<BigRequestTmpDto> dataDetails = this.bigDataTmpRepository.getByTaskId(taskId);
                    StringBuilder stringBuilder = new StringBuilder();
                    dataDetails.forEach(bq -> stringBuilder.append(bq.getContent()));
                    byte[] decodeChar = Base64Util.decode((byte[])stringBuilder.toString().getBytes(StandardCharsets.UTF_8));
                    if (request instanceof CustomHttpServletRequestWrapper) {
                        byte[] ungzipBody = GZipUtils.ungzip((byte[])decodeChar);
                        ((CustomHttpServletRequestWrapper)request).setBody(new String(ungzipBody).getBytes());
                    }
                    response.addHeader("big-request-finish", "true");
                    return true;
                }
                String sjycBody = "{\"code\":\"0\",\"message\":\"\u5927\u62a5\u6587\u62c6\u5206\u5f02\u5e38\u6570\u636e\u7f3a\u5931\",\"big-request-data-miss\":true}";
                response.getWriter().write(sjycBody);
                response.setStatus(500);
                response.addHeader("big-request-data-miss", "true");
                return false;
            }
            int splitIndex = Integer.valueOf(request.getHeader("big-data-split-index"));
            BigRequestTmpDto requestBody = new BigRequestTmpDto(taskId, splitIndex, body, DateFormatUtils.format((Date)new Date(), (String)"yyyyMMddHHmmss"));
            String sjycBody = "{\"code\":\"1\",\"message\":\"\u5df2\u7ecf\u4e0a\u4f20\"}";
            try {
                boolean result = this.bigDataTmpRepository.saveBigDataTmp(requestBody);
                if (result) {
                    response.setStatus(200);
                    response.getWriter().write(sjycBody);
                    return false;
                }
            }
            catch (Exception ex) {
                log.error("\u5927\u62a5\u6587\u7247\u6bb5\u4fdd\u5b58\u5931\u8d25:{} ,index:{}", (Object)taskId, (Object)splitIndex);
            }
            sjycBody = "{\"code\":\"0\",\"message\":\"\u4e0a\u4f20\u5931\u8d25\"}";
            response.getWriter().write(sjycBody);
            response.setStatus(500);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private StringBuilder getRequestBody(CustomHttpServletRequestWrapper request) {
        StringBuilder requestBodySB = new StringBuilder();
        try (BufferedReader br = request.getReader();){
            String line = null;
            while ((line = br.readLine()) != null) {
                requestBodySB.append(line);
            }
            br.close();
            StringBuilder stringBuilder = requestBodySB;
            return stringBuilder;
        }
        catch (IOException iOException) {
            return requestBodySB;
        }
    }

    public void setBigDataTmpRepository(BigDataTmpRepository bigDataTmpRepository) {
        this.bigDataTmpRepository = bigDataTmpRepository;
    }
}

