/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.interceptor;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.xforceplus.apollo.jx.exchange.Json2Json;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.config.HttpConfig;
import com.xforceplus.janus.config.core.dto.ApiDto;
import com.xforceplus.janus.config.core.dto.FieldMappingDto;
import com.xforceplus.janus.config.core.util.JanusHttpUtil;
import com.xforceplus.janus.framework.dto.JanusRequst;
import com.xforceplus.janus.framework.dto.Result;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessContentDto;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.init.ProjectCacheHandler;
import com.xforceplus.janus.framework.record.interceptor.CustomHttpServletRequestWrapper;
import com.xforceplus.janus.framework.record.interceptor.CustomHttpServletResponseWrapper;
import com.xforceplus.janus.framework.record.interceptor.IHttpDiyFlowHandler;
import com.xforceplus.janus.framework.util.IPUtils;
import com.xforceplus.janus.framework.util.RequestUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.HandlerInterceptor;

@Order(value=1)
public class RequestInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestInterceptor.class);
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    private ProjectCacheHandler projectCacheHandler;
    private HttpConfig httpConfig;
    private IHttpDiyFlowHandler diyFlowHandler;
    Set<String> EXCLUDES = new HashSet<String>(){
        {
            this.add("CONTENT-LENGTH");
            this.add("USER-AGENT");
            this.add("HOST");
            this.add("X-FORWARDED-CLUSTER");
            this.add("WEB-SERVER-TYPE");
            this.add("ACCEPT-ENCODING");
            this.add("AUTHENTICATION");
        }
    };

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        request.setAttribute("startTime", (Object)System.currentTimeMillis());
        String uri = request.getRequestURI();
        uri = uri.split("\\?")[0];
        String urlId = uri + request.getMethod();
        request.setAttribute("urlId", (Object)urlId);
        ApiDto apiDto = this.projectCacheHandler.getApiCache().get(urlId);
        if (apiDto == null && StringUtils.isNotBlank((CharSequence)request.getHeader("action"))) {
            apiDto = new ApiDto();
            apiDto.setBindAction(request.getHeader("action"));
            apiDto.setRequestMethod(request.getMethod());
        }
        if (apiDto == null) {
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/json");
            Result result = new Result();
            result.setCode("403");
            result.setMessage("\u8be5\u63a5\u53e3[" + uri + "]\u5c1a\u672a\u6ce8\u518c\uff0c\u8bf7\u8054\u7cfb\u7968\u6613\u901a\u96c6\u6210\u7ba1\u7406\u5458\u6ce8\u518c\u63a5\u53e3");
            response.getOutputStream().write(JacksonUtil.getInstance().toJson(result).getBytes());
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)apiDto.getBindAction())) {
            this.httpRequest(apiDto, request, response);
            this.afterCompletion(request, response, null, null);
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)apiDto.getId()) && this.projectCacheHandler.getHttpDiyFlowCache().containsKey(apiDto.getId())) {
            if (this.diyFlowHandler == null) {
                response.setStatus(HttpStatus.OK.value());
                response.setContentType("application/json");
                Result result = new Result();
                result.setCode("403");
                result.setMessage("\u8be5\u63a5\u53e3[" + uri + "]\u5b9a\u4e49\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7968\u6613\u901a\u96c6\u6210\u7ba1\u7406\u5458\u914d\u7f6e\u63a5\u53e3");
                response.getOutputStream().write(JacksonUtil.getInstance().toJson(result).getBytes());
                return false;
            }
            this.diyFlowHandler.flowDiyHandle(apiDto, request, response);
            this.afterCompletion(request, response, null, null);
            return false;
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        StringBuilder reqBody;
        if (request.getHeader("Content-Encoding") != null && request.getHeader("Content-Encoding").indexOf("gzip") >= 0) {
            return;
        }
        long startTime = (Long)request.getAttribute("startTime");
        String urlId = (String)request.getAttribute("urlId");
        ApiDto apiDto = this.projectCacheHandler.getApiCache().get(urlId);
        long cost = System.currentTimeMillis() - startTime;
        AccessRecord.AccessRecordBuilder builder = AccessRecord.builder().costTime(cost).requestTime(DateFormatUtils.format((long)startTime, (String)"yyyyMMddHHmmssSSS")).action(apiDto != null ? apiDto.getBindAction() : request.getRequestURI()).apiId(apiDto != null ? apiDto.getId() : "").serverProjectId(apiDto != null ? apiDto.getProjectId() : "").requestMethod(request.getMethod()).status(response.getStatus()).serialNo(request.getHeader("serialNo")).sourceIp(IPUtils.getIpAddr(request));
        AccessContentDto accessContentDto = new AccessContentDto();
        if (response instanceof CustomHttpServletResponseWrapper) {
            String responseBody = new String(((CustomHttpServletResponseWrapper)response).getBytes());
            accessContentDto.setResponseBody(responseBody);
            builder.reqDataLen(responseBody.getBytes(StandardCharsets.UTF_8).length);
        }
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerEnu = request.getHeaderNames();
        while (headerEnu.hasMoreElements()) {
            String key = (String)headerEnu.nextElement();
            if (this.EXCLUDES.contains(key.toUpperCase())) continue;
            headerMap.put(key, request.getHeader(key));
        }
        headerMap.put("RequestURI", request.getRequestURI());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (request.getContentType() != null && request.getContentType().contains(CONTENT_TYPE_MULTIPART)) {
            Enumeration paramEnu = request.getParameterNames();
            while (paramEnu.hasMoreElements()) {
                String key = (String)paramEnu.nextElement();
                paramMap.put(key, request.getParameter(key));
            }
        }
        accessContentDto.setRequestHeader(headerMap);
        accessContentDto.setRequestParam(paramMap);
        if (request.getInputStream() != null && !request.getInputStream().isFinished() && (reqBody = RequestUtil.getRequestBody(request)) != null && reqBody.length() > 0) {
            String reqBodyStr = reqBody.toString();
            accessContentDto.setRequestBody(reqBodyStr);
            builder.reqDataLen(reqBodyStr.getBytes(StandardCharsets.UTF_8).length);
        }
        if (StringUtils.isNotBlank((CharSequence)accessContentDto.getRequestBody()) && accessContentDto.getRequestBody().getBytes().length > 5120000) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)accessContentDto.getResponseBody()) && accessContentDto.getResponseBody().getBytes().length > 5120000) {
            return;
        }
        AccessRecord accessRecord = builder.build();
        accessRecord.setAccessContent(accessContentDto);
        try {
            AccessRecordCache.pushRecord(accessRecord);
        }
        catch (Exception exception) {
            log.error("record error:{}", (Object)accessRecord.toString());
        }
    }

    public void httpRequest(ApiDto apiDto, HttpServletRequest request, HttpServletResponse response) {
        String serailNo;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("Authentication", this.httpConfig.getAuthentication());
        headers.put("action", apiDto.getBindAction());
        headers.put("rpcType", "http");
        headers.put("Accept-Encoding", "deft");
        HashMap<String, String> params = new HashMap<String, String>();
        JanusRequst janusRequst = RequestUtil.readFromRequest(request);
        String janusRequestStr = JacksonUtil.getInstance().toJson((Object)janusRequst);
        if (CollectionUtils.isNotEmpty((Collection)apiDto.getHeaders())) {
            try {
                for (FieldMappingDto fieldMapping : apiDto.getHeaders()) {
                    if (StringUtils.isNotBlank((CharSequence)fieldMapping.getFieldValueName())) {
                        headers.put(fieldMapping.getFieldName(), JsonPath.read((String)janusRequestStr, (String)("$." + fieldMapping.getFieldValueName()), (Predicate[])new Predicate[0]));
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)fieldMapping.getDefaultValue())) continue;
                    headers.put(fieldMapping.getFieldName(), fieldMapping.getDefaultValue());
                }
            }
            catch (PathNotFoundException pnfe) {
                log.error("header json path not found", (Throwable)pnfe);
            }
        }
        if (MapUtils.isNotEmpty(janusRequst.getHeaders())) {
            for (Map.Entry<String, String> entry : janusRequst.getHeaders().entrySet()) {
                if (this.EXCLUDES.contains(entry.getKey().toUpperCase()) || headers.containsKey(entry.getKey().toUpperCase())) continue;
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        if (MapUtils.isNotEmpty(janusRequst.getParams())) {
            for (Map.Entry<String, String> entry : janusRequst.getParams().entrySet()) {
                if (params.containsKey(entry.getKey())) continue;
                params.put(entry.getKey(), entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)apiDto.getParams())) {
            try {
                for (FieldMappingDto paramMapping : apiDto.getParams()) {
                    if (StringUtils.isNotBlank((CharSequence)paramMapping.getFieldValueName())) {
                        headers.put(paramMapping.getFieldName(), JsonPath.read((String)janusRequestStr, (String)("$." + paramMapping.getFieldValueName()), (Predicate[])new Predicate[0]));
                        continue;
                    }
                    if (!StringUtils.isNotBlank((CharSequence)paramMapping.getDefaultValue())) continue;
                    headers.put(paramMapping.getFieldName(), paramMapping.getDefaultValue());
                }
            }
            catch (PathNotFoundException pnfe) {
                log.error("param json path not found", (Throwable)pnfe);
            }
        }
        String string = serailNo = StringUtils.isBlank((CharSequence)((CharSequence)headers.get("serialNo"))) ? (String)headers.get("serialNo".toLowerCase()) : (String)headers.get("serialNo");
        if (StringUtils.isBlank((CharSequence)serailNo)) {
            serailNo = "" + System.currentTimeMillis();
            headers.put("serialNo", serailNo);
        }
        if (request instanceof CustomHttpServletRequestWrapper) {
            ((CustomHttpServletRequestWrapper)request).addHeader("serialNo", serailNo);
        }
        try {
            String httpMethod;
            JanusHttpUtil.ResponseCus remoteResult = null;
            String body = null;
            if (janusRequst.getBody() != null) {
                String string2 = body = janusRequst.getBody() instanceof String ? (String)janusRequst.getBody() : JacksonUtil.getInstance().toJson(janusRequst.getBody());
            }
            if (StringUtils.isNotBlank((CharSequence)apiDto.getBodyExpression()) && StringUtils.isNotBlank(body)) {
                Json2Json json2Json = new Json2Json();
                body = json2Json.exchange(body, apiDto.getBodyExpression());
                log.info("\u8f6c\u6362\u540ebody:{}", (Object)body);
            }
            if (StringUtils.isBlank(body)) {
                body = "{}";
            }
            String string3 = httpMethod = StringUtils.isBlank((CharSequence)apiDto.getBindHttpMethod()) ? request.getMethod() : apiDto.getBindHttpMethod();
            if (httpMethod.equalsIgnoreCase("GET")) {
                remoteResult = JanusHttpUtil.doGetEntire((String)this.httpConfig.getUrl(), params, (boolean)true, headers);
            } else if (httpMethod.equalsIgnoreCase("POST")) {
                remoteResult = JanusHttpUtil.doPostJsonEntire((String)this.httpConfig.getUrl(), (String)body, headers, params);
            } else if (httpMethod.equalsIgnoreCase("PUT") || httpMethod.equalsIgnoreCase("PATCH")) {
                remoteResult = JanusHttpUtil.doPutPatchEntire((String)this.httpConfig.getUrl(), (String)httpMethod, (String)body, headers, params);
            } else if (httpMethod.equalsIgnoreCase("DELETE")) {
                remoteResult = JanusHttpUtil.doDeleteEntire((String)this.httpConfig.getUrl(), headers, params);
            }
            response.setStatus(remoteResult.getStatus());
            response.setContentType("application/json");
            response.getOutputStream().write(remoteResult.getBody().getBytes());
        }
        catch (IOException ex) {
            log.error(this.httpConfig.getUrl() + "\u5f02\u5e38", (Throwable)ex);
        }
    }

    public void setProjectCacheHandler(ProjectCacheHandler projectCacheHandler) {
        this.projectCacheHandler = projectCacheHandler;
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setDiyFlowHandler(IHttpDiyFlowHandler diyFlowHandler) {
        this.diyFlowHandler = diyFlowHandler;
    }
}

