/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.BeanMapperUtil;
import com.xforceplus.janus.framework.record.domain.BigRequestTmpDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;

public class BigDataTmpRepository {
    private static final Logger log = LoggerFactory.getLogger(BigDataTmpRepository.class);
    private NamedParameterJdbcTemplate namedPrmtrJdbcTemplate;
    private static final String insertSql = "insert into t_janus_big_request_tmp(task_id,task_index,content,created_time)values(:taskId,:taskIndex,:content,:createdTime)";
    private static final String queryByTaskId = "select * from  t_janus_big_request_tmp where task_id=:taskId order by task_index";
    private static final String queryOne = "select * from  t_janus_big_request_tmp where task_id=:taskId and  task_index=:index";
    private static final String SQL_COUNT_BT_TASKId = "select count(1) from  t_janus_big_request_tmp where task_id=:taskId";

    public boolean saveBigDataTmp(BigRequestTmpDto requestBody) {
        Map param = (Map)BeanMapperUtil.map((Object)requestBody, Map.class);
        int count = this.namedPrmtrJdbcTemplate.update(insertSql, param);
        return count == 1;
    }

    public List<BigRequestTmpDto> getByTaskId(String taskId) {
        return this.getByTaskId(taskId, true);
    }

    public List<BigRequestTmpDto> getByTaskId(final String taskId, final boolean fullField) {
        List acc = null;
        HashMap<String, String> param = new HashMap<String, String>(){
            {
                this.put("taskId", taskId);
            }
        };
        try {
            acc = this.namedPrmtrJdbcTemplate.query(queryByTaskId, (Map)param, (RowMapper)new RowMapper<BigRequestTmpDto>(){

                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    if (fullField) {
                        requestTmpDto.setContent(rs.getString("content"));
                    }
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));
                    return requestTmpDto;
                }
            });
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return acc;
    }

    public BigRequestTmpDto queryOne(final String taskId, final Integer index) {
        List acc = null;
        HashMap<String, Object> param = new HashMap<String, Object>(){
            {
                this.put("taskId", taskId);
                this.put("index", index);
            }
        };
        try {
            acc = this.namedPrmtrJdbcTemplate.query(queryOne, (Map)param, (RowMapper)new RowMapper<BigRequestTmpDto>(){

                public BigRequestTmpDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                    BigRequestTmpDto requestTmpDto = new BigRequestTmpDto();
                    requestTmpDto.setTaskId(rs.getString("task_id"));
                    requestTmpDto.setTaskIndex(rs.getInt("task_index"));
                    requestTmpDto.setContent(rs.getString("content"));
                    requestTmpDto.setCreatedTime(rs.getString("created_time"));
                    return requestTmpDto;
                }
            });
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            // empty catch block
        }
        return CollectionUtils.isEmpty(acc) ? null : (BigRequestTmpDto)acc.get(0);
    }

    public int countByTaskId(final String taskId) {
        HashMap<String, String> param = new HashMap<String, String>(){
            {
                this.put("taskId", taskId);
            }
        };
        List counts = this.namedPrmtrJdbcTemplate.query(SQL_COUNT_BT_TASKId, (Map)param, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet resultSet, int i) throws SQLException {
                return resultSet.getInt(1);
            }
        });
        return CollectionUtils.isEmpty((Collection)counts) ? 0 : (Integer)counts.get(0);
    }

    public void setNamedPrmtrJdbcTemplate(NamedParameterJdbcTemplate namedPrmtrJdbcTemplate) {
        this.namedPrmtrJdbcTemplate = namedPrmtrJdbcTemplate;
    }
}

