/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.config.core.monitor.JanusUploader;
import com.xforceplus.janus.config.core.monitor.param.MonitorParam;
import com.xforceplus.janus.framework.record.cache.AccessRecordCache;
import com.xforceplus.janus.framework.record.domain.AccessRecord;
import com.xforceplus.janus.framework.record.portal.AccessRecordConsumer;
import com.xforceplus.janus.framework.record.service.AccessRecordService;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DbAccessRecordConsumer
implements AccessRecordConsumer {
    private static final Logger log = LoggerFactory.getLogger(DbAccessRecordConsumer.class);
    @Autowired
    private AccessRecordService accessRecordService;
    private static boolean tableExist = true;
    @Autowired
    private JanusUploader janusUploader;
    long lastSendTime = 0L;
    long successCount = 0L;
    long failedCount = 0L;

    @Override
    public void consumeAccessRecord() {
        while (true) {
            try {
                while (true) {
                    List<AccessRecord> records;
                    if (CollectionUtils.isEmpty(records = AccessRecordCache.takeBatch())) {
                        continue;
                    }
                    if (tableExist) {
                        this.accessRecordService.saveBatch(records);
                        continue;
                    }
                    String recordStr = JacksonUtil.getInstance().toJson(records);
                    log.info(recordStr);
                }
            }
            catch (InterruptedException records) {
                continue;
            }
            catch (Throwable tr) {
                if (tr.getMessage() != null && tr.getMessage().contains("exist")) {
                    tableExist = false;
                }
                log.error("saveBatch  AccessRecord error", tr);
                continue;
            }
            break;
        }
    }

    public void noticeException(AccessRecord record) {
        if (record.getStatus() != 200) {
            ++this.failedCount;
        } else {
            ++this.successCount;
        }
        if (this.lastSendTime > 0L && System.currentTimeMillis() - this.lastSendTime < 300000L) {
            return;
        }
        if (this.failedCount > 0L && StringUtils.isNotBlank((CharSequence)record.getAction())) {
            MonitorParam monitorParam = new MonitorParam();
            monitorParam.setDataType("http");
            monitorParam.setNoticeType("email");
            monitorParam.setNoticeContent(String.format("projectName \u63a5\u53e3[%s]\u5f02\u5e38\uff0c\u72b6\u6001\u7801:%d", record.getAction(), record.getStatus()));
            monitorParam.setSubject("\u63a5\u53e3\u5f02\u5e38");
            monitorParam.setObjectId(record.getAction());
            monitorParam.setMonitorType("service");
            monitorParam.setIndicator("service_error");
            this.janusUploader.uploadMonitor(monitorParam);
            this.lastSendTime = System.currentTimeMillis();
        }
        this.successCount = 0L;
        this.failedCount = 0L;
    }
}

