/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.record.portal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.condition.RequestMethodsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RestUrlUploader {
    private static final Logger log = LoggerFactory.getLogger(RestUrlUploader.class);
    WebApplicationContext webApplicationContext;

    public List<Map<String, String>> getUrl() {
        RequestMappingHandlerMapping mapping = (RequestMappingHandlerMapping)this.webApplicationContext.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        if (mapping == null) {
            return null;
        }
        Map map = mapping.getHandlerMethods();
        ArrayList<Map<String, String>> listMap = new ArrayList<Map<String, String>>();
        for (Map.Entry entry : map.entrySet()) {
            HashMap<String, String> initMap = new HashMap<String, String>();
            RequestMappingInfo info = (RequestMappingInfo)entry.getKey();
            RequestMethodsRequestCondition methodsCondition = info.getMethodsCondition();
            PatternsRequestCondition pattern = info.getPatternsCondition();
            Set methods = methodsCondition.getMethods();
            if (ObjectUtils.isEmpty((Object)pattern) || CollectionUtils.isEmpty((Collection)methods)) continue;
            if (!CollectionUtils.isEmpty((Collection)pattern.getPatterns())) {
                Set patterns = pattern.getPatterns();
                for (String url : patterns) {
                    initMap.put("requestPath", url);
                    initMap.put("name", url.replaceAll("/", "_").substring(1));
                }
                for (RequestMethod requestMethod : methods) {
                    initMap.put("requestMethod", requestMethod.toString().toUpperCase());
                }
            }
            listMap.add(initMap);
        }
        return listMap;
    }

    public void setWebApplicationContext(WebApplicationContext webApplicationContext) {
        this.webApplicationContext = webApplicationContext;
    }
}

