/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateUtils {
    public static final String DATE_PATTERN = "yyyy-MM-dd";
    public static final String DATE_PATTERN_NO = "yyyyMMdd";
    public static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_TIME_PATTERN1 = "yyyyMMddHHmmssSSS";
    public static final String DATE_PATTERN_H = "yyyyMMddHH";
    public static final String DATE_PATTERN_H2 = "yyyy-MM-dd HH";

    public static String format(Date date) {
        return DateUtils.format(date, DATE_PATTERN);
    }

    public static String format(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        String datePattern = pattern;
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            datePattern = DATE_TIME_PATTERN;
        }
        FastDateFormat dateFormat = FastDateFormat.getInstance((String)datePattern);
        return dateFormat.format(date);
    }

    public static Date stringToDate(String strDate, String pattern) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)pattern);
        return fmt.parseLocalDateTime(strDate).toDate();
    }

    public static Date addDateSeconds(Date date, int seconds) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusSeconds(seconds).toDate();
    }

    public static Date addDateMinutes(Date date, int minutes) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusMinutes(minutes).toDate();
    }

    public static Date addDateHours(Date date, int hours) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusHours(hours).toDate();
    }

    public static Date addDateDays(Date date, int days) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusDays(days).toDate();
    }

    public static Date addDateWeeks(Date date, int weeks) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusWeeks(weeks).toDate();
    }

    public static Date addDateMonths(Date date, int months) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusMonths(months).toDate();
    }

    public static Date addDateYears(Date date, int years) {
        DateTime dateTime = new DateTime((Object)date);
        return dateTime.plusYears(years).toDate();
    }

    public static Date[] getWeekStartAndEnd(int week) {
        DateTime dateTime = new DateTime();
        LocalDate date = new LocalDate((Object)dateTime.plusWeeks(week));
        date = date.dayOfWeek().withMinimumValue();
        Date beginDate = date.toDate();
        Date endDate = date.plusDays(6).toDate();
        return new Date[]{beginDate, endDate};
    }

    public static String[] getDayStartAndEnd(Date date) {
        String endDate = DateUtils.format(DateUtils.endOfDay(date), DATE_TIME_PATTERN);
        String beginDate = DateUtils.format(DateUtils.beginOfDay(date), DATE_TIME_PATTERN);
        return new String[]{beginDate, endDate};
    }

    public static String[] getHourStartAndEnd(Date date) {
        String beginDate = DateUtils.format(DateUtils.beginOfHour(date), DATE_TIME_PATTERN);
        String endDate = DateUtils.format(DateUtils.endOfHour(date), DATE_TIME_PATTERN);
        return new String[]{beginDate, endDate};
    }

    public static Date beginOfHour(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfHour(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date beginOfDay(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static Date endOfDay(Date date) {
        Calendar calendar = DateUtils.calendar(date);
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return new Date(calendar.getTimeInMillis());
    }

    public static Calendar calendar(Date date) {
        return DateUtils.calendar(date.getTime());
    }

    public static Calendar calendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(millis);
        return cal;
    }

    public static List<String> getRangeDate(Date beginDate, Date endDate, int field, String format) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(DateUtils.format(beginDate, format));
        while (beginDate.before(endDate)) {
            Calendar calendar = DateUtils.calendar(beginDate);
            calendar.add(field, 1);
            beginDate = new Date(calendar.getTimeInMillis());
            result.add(DateUtils.format(beginDate, format));
        }
        return result;
    }

    public static String getfirstDayOfPrevMonth() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_NO);
        Calendar cal_1 = Calendar.getInstance();
        cal_1.add(2, -1);
        cal_1.set(5, 1);
        String firstDay = format.format(cal_1.getTime());
        return firstDay;
    }

    public static String getfirstDayOfCurMonth() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_NO);
        Calendar c = Calendar.getInstance();
        c.add(2, 0);
        c.set(5, 1);
        String first = format.format(c.getTime());
        return first;
    }

    public static String getLastDay(String ym) {
        String last = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_NO);
            String ymd = ym + "01";
            Calendar ca = DateUtils.calendar(format.parse(ymd));
            ca.set(5, ca.getActualMaximum(5));
            last = format.format(ca.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return last;
    }

    public static String getLastDay(String ymd, String pattern) {
        String last = "";
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            Calendar ca = DateUtils.calendar(format.parse(ymd));
            ca.set(5, ca.getActualMaximum(5));
            last = format.format(ca.getTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return last;
    }

    public static String getlastDayOfPrevMonth() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_NO);
        Calendar cale = Calendar.getInstance();
        cale.set(5, 0);
        String lastDay = format.format(cale.getTime());
        return lastDay;
    }

    public static String getlastDayOfCurMonth() {
        SimpleDateFormat format = new SimpleDateFormat(DATE_PATTERN_NO);
        Calendar ca = Calendar.getInstance();
        ca.set(5, ca.getActualMaximum(5));
        String last = format.format(ca.getTime());
        return last;
    }
}

