/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.utils.ErrorUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPUtils {
    private static final Logger log = LoggerFactory.getLogger(IPUtils.class);
    private static Logger logger = LoggerFactory.getLogger(IPUtils.class);

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("WL-Proxy-Client-IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_CLIENT_IP");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getHeader("HTTP_X_FORWARDED_FOR");
            }
            if (StringUtils.isEmpty((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
                ip = request.getRemoteAddr();
            }
        }
        catch (Exception e) {
            logger.error("IPUtils ERROR ", (Throwable)e);
        }
        String ipSeparate = ",";
        int ipLength = 15;
        if (ip != null && ip.length() > ipLength && ip.indexOf(ipSeparate) > 0) {
            ip = ip.substring(0, ip.indexOf(ipSeparate));
        }
        return ip;
    }

    public static List<String> getIpAddress() {
        LinkedList<String> list = new LinkedList<String>();
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface network = enumeration.nextElement();
                Enumeration<InetAddress> addresses = network.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress address = addresses.nextElement();
                    if (address == null || !(address instanceof Inet4Address) || "127.0.0.1".equals(address.getHostAddress())) continue;
                    list.add(address.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            log.error(ErrorUtil.getStackMsg((Exception)e));
        }
        catch (Error e) {
            log.error(ErrorUtil.getStackMsg((Throwable)e));
        }
        return list;
    }

    public static void main(String[] args) {
        List<String> list = IPUtils.getIpAddress();
        for (String ip : list) {
            System.out.println(ip);
        }
    }
}

