/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.utils.ErrorUtil;
import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.dto.LogFileDescribeCacheDto;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyFileUtils {
    private static final Logger log = LoggerFactory.getLogger(MyFileUtils.class);
    public static final String TRANSFER_FILE_KEY = "janus_transfer_file_url";
    public static final String TRANSFER_FILE_NAME = "janus_transfer_file_name";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUnGzip(String sourceFilePath, String targetFilePath) {
        FileOutputStream out = null;
        GZIPInputStream fis = null;
        try {
            int count;
            fis = new GZIPInputStream(new FileInputStream(sourceFilePath));
            File target = new File(targetFilePath);
            out = new FileOutputStream(target);
            byte[] data = new byte[0x200000];
            while ((count = fis.read(data, 0, 0x200000)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static LogFileDescribeCacheDto readCache(String fileName) {
        LogFileDescribeCacheDto dto = null;
        File file = new File(fileName);
        try {
            String cacheStr = FileUtils.readFileToString((File)file, (String)"utf-8");
            if (StringUtils.isNotBlank((CharSequence)cacheStr)) {
                dto = (LogFileDescribeCacheDto)JacksonUtil.getInstance().fromJson(cacheStr, LogFileDescribeCacheDto.class);
            }
        }
        catch (Exception e) {
            log.error(fileName + " \u8bfb\u53d6\u9519\u8bef:" + ErrorUtil.getStackMsg((Exception)e));
        }
        if (dto == null) {
            dto = new LogFileDescribeCacheDto();
        }
        return dto;
    }

    public static void writeCache(String fileName, LogFileDescribeCacheDto dto) {
        File file = new File(fileName);
        try {
            FileUtils.writeStringToFile((File)file, (String)JacksonUtil.getInstance().toJson((Object)dto), (String)"UTF-8");
        }
        catch (Exception var4) {
            log.error(fileName + " \u5199\u5165\u5931\u8d25:" + ErrorUtil.getStackMsg((Exception)var4));
        }
    }

    public static void copyFile(File srcFile, File destFile) {
        try {
            FileUtils.copyFile((File)srcFile, (File)destFile);
        }
        catch (Exception var4) {
            log.error("copyFile \u5199\u5165\u5931\u8d25:" + ErrorUtil.getStackMsg((Exception)var4));
        }
    }
}

