/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.framework.util;

import com.xforceplus.apollo.utils.JacksonUtil;
import com.xforceplus.janus.framework.dto.JanusRequst;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class RequestUtil {
    public static JanusRequst readFromRequest(HttpServletRequest request) {
        JanusRequst janusRequst = new JanusRequst();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        Enumeration headerEnu = request.getHeaderNames();
        while (headerEnu.hasMoreElements()) {
            String key = (String)headerEnu.nextElement();
            headerMap.put(key, request.getHeader(key));
        }
        janusRequst.setHeaders(headerMap);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Enumeration paramEnu = request.getParameterNames();
        while (paramEnu.hasMoreElements()) {
            String key = (String)paramEnu.nextElement();
            paramMap.put(key, request.getParameter(key));
        }
        janusRequst.setParams(paramMap);
        String reqBody = RequestUtil.getRequestBody(request).toString();
        if (JacksonUtil.getInstance().isJsonArray(reqBody)) {
            janusRequst.setBody(JacksonUtil.getInstance().fromJsonToList(reqBody, Map.class));
        } else if (JacksonUtil.getInstance().isJson(reqBody)) {
            janusRequst.setBody(JacksonUtil.getInstance().fromJson(reqBody, Map.class));
        } else {
            janusRequst.setBody(reqBody);
        }
        return janusRequst;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StringBuilder getRequestBody(HttpServletRequest request) {
        StringBuilder requestBodySB = new StringBuilder();
        try (BufferedReader br = request.getReader();){
            String line = null;
            while ((line = br.readLine()) != null) {
                requestBodySB.append(line);
            }
            br.close();
            StringBuilder stringBuilder = requestBodySB;
            return stringBuilder;
        }
        catch (IOException iOException) {
            return requestBodySB;
        }
    }
}

