/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.janus.generator.util;

import com.xforceplus.janus.generator.config.GenConfig;
import com.xforceplus.janus.generator.domain.GenTable;
import com.xforceplus.janus.generator.domain.GenTableColumn;
import com.xforceplus.janus.generator.util.GenConstants;
import com.xforceplus.janus.generator.util.StringUtils;
import java.util.Arrays;

public class GenUtils {
    public static void initTable(GenTable genTable, String operName) {
        genTable.setClassName(GenUtils.convertClassName(genTable.getTableName()));
        genTable.setPackageName(GenConfig.packageName);
        genTable.setModuleName(GenUtils.getModuleName(GenConfig.packageName));
        genTable.setBusinessName(GenUtils.getBusinessName(genTable.getTableName()));
    }

    public static void initColumnField(GenTableColumn column, GenTable table) {
        String dataType = GenUtils.getDbType(column.getColumnType());
        String columnName = column.getColumnName();
        column.setTableId(table.getTableId());
        column.setJavaField(StringUtils.toCamelCase(columnName));
        if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_STR, dataType)) {
            column.setJavaType("String");
            Integer columnLength = GenUtils.getColumnLength(column.getColumnType());
            String htmlType = columnLength >= 500 ? "textarea" : "input";
            column.setHtmlType(htmlType);
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_TIME, dataType)) {
            column.setJavaType("Date");
            column.setHtmlType("datetime");
        } else if (GenUtils.arraysContains(GenConstants.COLUMNTYPE_NUMBER, dataType)) {
            column.setHtmlType("input");
            String[] str = StringUtils.split((String)StringUtils.substringBetween((String)column.getColumnType(), (String)"(", (String)")"), (String)",");
            if (str != null && str.length == 2 && Integer.parseInt(str[1]) > 0) {
                column.setJavaType("Double");
            } else if (str != null && str.length == 1 && Integer.parseInt(str[0]) <= 10) {
                column.setJavaType("Integer");
            } else {
                column.setJavaType("Long");
            }
        }
        column.setIsInsert("1");
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_EDIT, columnName) && !column.isPk()) {
            column.setIsEdit("1");
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_LIST, columnName) && !column.isPk()) {
            column.setList(true);
        }
        if (!GenUtils.arraysContains(GenConstants.COLUMNNAME_NOT_QUERY, columnName) && !column.isPk()) {
            column.setQuery(true);
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"name")) {
            column.setQueryType("LIKE");
        }
        if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"status")) {
            column.setHtmlType("radio");
        } else if (StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"type") || StringUtils.endsWithIgnoreCase((CharSequence)columnName, (CharSequence)"sex")) {
            column.setHtmlType("select");
        }
    }

    public static boolean arraysContains(String[] arr, String targetValue) {
        return Arrays.asList(arr).contains(targetValue);
    }

    public static String getModuleName(String packageName) {
        int lastIndex = packageName.lastIndexOf(".");
        int nameLength = packageName.length();
        String moduleName = StringUtils.substring((String)packageName, (int)(lastIndex + 1), (int)nameLength);
        return moduleName;
    }

    public static String getBusinessName(String tableName) {
        int lastIndex = tableName.lastIndexOf("_");
        int nameLength = tableName.length();
        String businessName = StringUtils.substring((String)tableName, (int)(lastIndex + 1), (int)nameLength);
        return businessName;
    }

    public static String convertClassName(String tableName) {
        boolean autoRemovePre = GenConfig.autoRemovePre;
        String tablePrefix = GenConfig.tablePrefix;
        if (autoRemovePre && StringUtils.isNotEmpty((CharSequence)tablePrefix)) {
            String[] searchList = StringUtils.split((String)tablePrefix, (String)",");
            tableName = GenUtils.replaceFirst(tableName, searchList);
        }
        return StringUtils.convertToCamelCase(tableName);
    }

    public static String replaceFirst(String replacementm, String[] searchList) {
        String text = replacementm;
        for (String searchString : searchList) {
            if (!replacementm.startsWith(searchString)) continue;
            text = replacementm.replaceFirst(searchString, "");
            break;
        }
        return text;
    }

    public static String getDbType(String columnType) {
        if (StringUtils.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            return StringUtils.substringBefore((String)columnType, (String)"(");
        }
        return columnType;
    }

    public static Integer getColumnLength(String columnType) {
        if (StringUtils.indexOf((CharSequence)columnType, (CharSequence)"(") > 0) {
            String length = StringUtils.substringBetween((String)columnType, (String)"(", (String)")");
            return Integer.valueOf(length);
        }
        return 0;
    }

    public static String[] emptyList(int length) {
        String[] values = new String[length];
        for (int i = 0; i < length; ++i) {
            values[i] = "";
        }
        return values;
    }
}

