package com.xforceplus.janus.generator.domain;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.janus.commons.dto.BaseEntity;
import com.xforceplus.janus.generator.dto.ModelPropertyDto;


import java.util.List;

import javax.validation.constraints.NotBlank;

import lombok.Data;

/**
 * 业务表 gen_table
 *
 * @author just
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@Data
@TableName("t_janus_assist_model")
public class GenModel extends BaseEntity {
    private static final long serialVersionUID = 1L;
    public static final String MODULE_NAME = "sys";

    /**
     * 编号
     */
    @TableId
    private String id;

    private String projectId;
    private String fromProjectId;


    /**
     * 实体类名称(首字母大写)
     */
    @NotBlank(message = "实体类名称不能为空")
    private String className;

    /**
     * 说明
     */
    private String classComment;

    /**
     * 生成包路径
     */
    @NotBlank(message = "生成包路径不能为空")
    private String packageName;

    /**
     * 生成模块名
     */
    private String moduleName;

    /**
     * 生成业务名 className 驼峰
     */
    private String businessName;

    /**
     * 生成作者
     */
    private String functionAuthor;

    /**
     * 字段定义详情
     */
    private String property;

    @TableField(exist = false)
    List<ModelPropertyDto> properties;

    public GenModel() {

    }

    public GenModel(String projectId, String className, String classComment) {
        this.projectId = projectId;
        this.className = className;
        this.classComment = classComment;
    }

    public GenModel(String className, List<ModelPropertyDto> properties) {
        this.className = className;
        this.properties = properties;
    }

}