package com.xforceplus.janus.generator.domain;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.janus.generator.util.GenConstants;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import javax.validation.constraints.NotBlank;

import lombok.Data;

/**
 * 业务表 gen_table
 *
 * @author just
 */
@Data
@TableName("t_gen_table")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class GenTable  {
    private static final long serialVersionUID = 1L;
    public static final String MODULE_NAME = "sys";

    /**
     * 1-有效，0-无效
     * */
    @TableField(value = "is_valid")
    private Integer isValid = Integer.valueOf(1);
    /**
     * 1-锁定，0-正常
     * */
    @TableField(value = "is_lock")
    private Integer isLock = Integer.valueOf(0);

    @TableField(fill = FieldFill.INSERT)
    private String creator;

    @TableField(fill = FieldFill.INSERT)
    private String createdTime;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String modifier;


    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String modifiedTime;

    private String remark;

    /**
     * 编号
     */
    @TableId(type = IdType.AUTO)
    private Long tableId;

    private String projectId;

    /**
     * 表名称
     */
    @NotBlank(message = "表名称不能为空")
    private String tableName;

    /**
     * 表描述
     */
    @NotBlank(message = "表描述不能为空")
    private String tableComment;

    /**
     * 实体类名称(首字母大写)
     */
    @NotBlank(message = "实体类名称不能为空")
    private String className;

    /**
     * 使用的模板（crud单表操作 tree树表操作sub 主子表操作)
     */
    private String tplCategory;

    /**
     * 生成包路径
     */
    @NotBlank(message = "生成包路径不能为空")
    private String packageName;

    /**
     * 生成模块名
     */
//    @NotBlank(message = "生成模块名不能为空")
    private String moduleName;

    /**
     * 生成业务名
     */
//    @NotBlank(message = "生成业务名不能为空")
    private String businessName;

    /**
     * 生成功能名
     */
    @NotBlank(message = "生成功能名不能为空")
    private String functionName;

    /**
     * 生成作者
     */
    @NotBlank(message = "作者不能为空")
    private String functionAuthor;

    /**
     * 主键信息
     */
    @TableField(exist = false)
    private GenTableColumn pkColumn;

    /**
     * 表列信息
     */
    @TableField(exist = false)
    private List<GenTableColumn> columns;

    /**
     * 其它生成选项
     */
    private String options;

    /**
     * 树编码字段
     */
    @TableField(exist = false)
    private String treeCode;

    /**
     * 树父编码字段
     */
    @TableField(exist = false)
    private String treeParentCode;

    /**
     * 树名称字段
     */
    @TableField(exist = false)
    private String treeName;

    /**
     * 是否允许更新
     */
    private boolean enableUpdate;

    /**
     * 子表Class Name
     */
    @TableField(exist = false)
    private String subClassName;

    private String subTableName;

    /**
     * 从表属性字段名，比如details
     */
    private String subClassFieldName;

    /**
     * 子表外键 存放在从表中
     */
    private String subTableFkName;

    /**
     * 子表信息
     */
    @TableField(exist = false)
    private List<GenTable> subTables;

    //   存放在从表中，主表名称
    private String parentTableName;


    public boolean isTree() {
        return isTree(this.tplCategory);
    }

    public static boolean isTree(String tplCategory) {
        return tplCategory != null && StringUtils
                .equals(GenConstants.TPL_TREE, tplCategory);
    }



    //主从表模式
    public boolean isSub() {
        return tplCategory != null && StringUtils.equals(GenConstants.TPL_SUB, tplCategory);
    }

    public boolean isCrud() {
        return isCrud(this.tplCategory);
    }

    public static boolean isCrud(String tplCategory) {
        return tplCategory != null && StringUtils.equals(GenConstants.TPL_CRUD, tplCategory);
    }


    public boolean isSuperColumn(String javaField) {
        return isSuperColumn(this.tplCategory, javaField);
    }


    public static boolean isSuperColumn(String tplCategory, String javaField) {
        if (isTree(tplCategory)) {
            return StringUtils.equalsAnyIgnoreCase(javaField,
                    ArrayUtils.addAll(GenConstants.TREE_ENTITY, GenConstants.BASE_ENTITY));
        }
        return StringUtils.equalsAnyIgnoreCase(javaField, GenConstants.BASE_ENTITY);
    }

    @JsonIgnore
    public List<GenTableColumn> getUnionKey() {
        List<GenTableColumn> unionKeys = new ArrayList<>();
        for (GenTableColumn cl : this.columns) {
            if (cl.isUnionKey()) {
                unionKeys.add(cl);
            }
        }
        return unionKeys;
    }

    public GenTableColumn getColumn(String javaField) {
        Optional<GenTableColumn> columnOpt = this.columns.stream().filter(cl -> cl.getJavaField().equals(javaField)).findFirst();
        if (columnOpt.isPresent()) {
            return columnOpt.get();
        }
        return null;
    }

    //
    public GenTable toSimple() {
        GenTable simple = new GenTable();
        simple.setTableName(this.tableName);
        simple.setBusinessName(this.businessName);
        simple.setEnableUpdate(this.enableUpdate);
        if (CollectionUtils.isNotEmpty(this.columns)) {
            List<GenTableColumn> simpleCols = new ArrayList<>();
            this.columns.forEach(col -> simpleCols.add(col.toSimple()));
            simple.setColumns(simpleCols);
        }

        if (CollectionUtils.isNotEmpty(this.subTables)) {
            this.subTables.forEach(tb->tb.toSimple());
        }
        return simple;
    }

}