package com.xforceplus.janus.generator.domain;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;

import lombok.Data;

/**
 * 代码生成业务字段表 gen_table_column
 * 
 * @author just
 */
@Data
@TableName("t_gen_table_column")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_EMPTY)
public class GenTableColumn {
    private static final long serialVersionUID = 1L;

    /**
     * 1-有效，0-无效
     * */
    @TableField(value = "is_valid")
    private Integer isValid = Integer.valueOf(1);
    /**
     * 1-锁定，0-正常
     * */
    @TableField(value = "is_lock")
    private Integer isLock = Integer.valueOf(0);

    @TableField(fill = FieldFill.INSERT)
    private String creator;

    @TableField(fill = FieldFill.INSERT)
    private String createdTime;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String modifier;


    @TableField(fill = FieldFill.INSERT_UPDATE)
    private String modifiedTime;

    private String remark;

    /** 编号 */
    @TableId(type = IdType.AUTO)
    private Long columnId;

    /** 归属表编号 */
    private Long tableId;

    /** 列名称 */
    private String columnName;

    /** 列描述 */
    private String columnComment;

    /** 列类型 */
    private String columnType;

    /** JAVA类型 */
    private String javaType;

    /** JAVA字段名 */
    @NotBlank(message = "Java属性不能为空")
    private String javaField;

    /** 是否主键（1是） */
    @TableField("is_pk")
    private boolean pk;

    /** 是否自增（1是） */
    @TableField("is_increment")
    private boolean increment;

    /** 是否必填（1是） */
    private String isRequired;

    /** 是否为插入字段（1是） */
    private String isInsert;

    /** 是否编辑字段（1是） */
    private String isEdit;

    /** 是否列表字段（1是） */
    @TableField("is_list")
    private boolean list;

    /** 是否业务联合主键（1是） */
    private boolean unionKey;

    /**宽度*/
    private int width;

    /** 是否查询字段（1是） */
    @TableField("is_query")
    private boolean query;

    /** 查询方式（EQ等于、NE不等于、GT大于、LT小于、LIKE模糊、BETWEEN范围） */
    private String queryType;

    /** 显示类型（input文本框、textarea文本域、select下拉框、checkbox复选框、radio单选框、datetime日期控件） */
    private String htmlType;

    /** 字典类型 */
    private String dictType;

    /** 排序 */
    private Integer sort;

    @TableField(exist = false)
    private boolean toUpdate=false;



    public GenTableColumn(){}

    public GenTableColumn(Long columnId,int isValid){
        this.columnId = columnId;
        this.setIsValid(isValid);
    }

    public String getCapJavaField()
    {
        return StringUtils.capitalize(javaField);
    }

    public boolean isRequired()
    {
        return isRequired(this.isRequired);
    }

    public boolean isRequired(String isRequired)
    {
        return isRequired != null && StringUtils.equals("1", isRequired);
    }

    public boolean isInsert()
    {
        return isInsert(this.isInsert);
    }

    public boolean isInsert(String isInsert)
    {
        return isInsert != null && StringUtils.equals("1", isInsert);
    }

    public void setIsEdit(String isEdit)
    {
        this.isEdit = isEdit;
    }

    public String getIsEdit()
    {
        return isEdit;
    }

    public boolean isEdit()
    {
        return isInsert(this.isEdit);
    }

    public boolean isEdit(String isEdit)
    {
        return isEdit != null && StringUtils.equals("1", isEdit);
    }


    public boolean isSuperColumn()
    {
        return isSuperColumn(this.javaField);
    }

    public static boolean isSuperColumn(String javaField)
    {
        return StringUtils.equalsAnyIgnoreCase(javaField,
                //BaseEntity
                "createBy", "createTime", "updateBy", "updateTime", "remark",
                //TreeEntity
                "parentName", "parentId", "orderNum", "ancestors");
    }

    public boolean isUsableColumn()
    {
        return isUsableColumn(javaField);
    }

    public static boolean isUsableColumn(String javaField)
    {
        //isSuperColumn()中的名单用于避免生成多余Domain属性，若某些属性在生成页面时需要用到不能忽略，则放在此处白名单
        return StringUtils.equalsAnyIgnoreCase(javaField, "parentId" , "orderNum");
    }

    public String readConverterExp()
    {
        String remarks = StringUtils.substringBetween(this.columnComment, "（", "）");
        StringBuffer sb = new StringBuffer();
        if (StringUtils.isNotEmpty(remarks))
        {
            for (String value : remarks.split(" "))
            {
                if (StringUtils.isNotEmpty(value))
                {
                    Object startStr = value.subSequence(0, 1);
                    String endStr = value.substring(1);
                    sb.append("").append(startStr).append("=").append(endStr).append(",");
                }
            }
            return sb.deleteCharAt(sb.length() - 1).toString();
        }
        else
        {
            return this.columnComment;
        }
    }


    public GenTableColumn toSimple(){
        GenTableColumn simple =new GenTableColumn();
        simple.setColumnName(this.columnName);
        simple.setJavaField(this.javaField);
        simple.setJavaType(this.javaType);
        simple.setIncrement(this.increment);
        simple.setUnionKey(this.unionKey);
        simple.setPk(this.pk);
        return simple;
    }
}